/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.ReplicaManager;
import io.confluent.kafkarest.entities.PartitionReplica;
import io.confluent.kafkarest.entities.v3.ReplicaData;
import io.confluent.kafkarest.entities.v3.ReplicaDataList;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.entities.v3.SearchReplicasByBrokerResponse;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;

@Path(value="/v3/clusters/{clusterId}/brokers/{brokerId}/partition-replicas")
@ResourceAccesslistFeature.ResourceName(value="api.v3.replicas.*")
public final class SearchReplicasByBrokerAction {
    private final Provider<ReplicaManager> replicaManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public SearchReplicasByBrokerAction(Provider<ReplicaManager> replicaManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.replicaManager = Objects.requireNonNull(replicaManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.brokers.partition-replicas.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.replicas.search-by-broker")
    public void searchReplicasByBroker(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="brokerId") Integer brokerId) {
        CompletionStage response = ((ReplicaManager)this.replicaManager.get()).searchReplicasByBrokerId(clusterId, brokerId).thenApply(replicas -> SearchReplicasByBrokerResponse.create((ReplicaDataList)((ReplicaDataList.Builder)((ReplicaDataList.Builder)ReplicaDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", clusterId, "brokers", Integer.toString(brokerId), "partition-replicas")).build())).setData(replicas.stream().sorted(Comparator.comparing(PartitionReplica::getTopicName).thenComparing(PartitionReplica::getPartitionId)).map(this::toReplicaData).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    private ReplicaData toReplicaData(PartitionReplica replica) {
        return ((ReplicaData.Builder)ReplicaData.fromPartitionReplica(replica).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", replica.getClusterId(), "topics", replica.getTopicName(), "partitions", Integer.toString(replica.getPartitionId()), "replicas", Integer.toString(replica.getBrokerId()))).setResourceName(this.crnFactory.create("kafka", replica.getClusterId(), "topic", replica.getTopicName(), "partition", Integer.toString(replica.getPartitionId()), "replica", Integer.toString(replica.getBrokerId()))).build())).setBroker(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", replica.getClusterId(), "brokers", Integer.toString(replica.getBrokerId())))).build();
    }
}

