/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.migration;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.loader.LoaderManifestType;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.migration.KRaftMigrationOperation;
import org.apache.kafka.metadata.migration.KRaftMigrationOperationConsumer;
import org.apache.kafka.metadata.migration.KRaftMigrationZkWriter;
import org.apache.kafka.metadata.migration.LegacyPropagator;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.metadata.migration.MigrationClientAuthException;
import org.apache.kafka.metadata.migration.MigrationClientException;
import org.apache.kafka.metadata.migration.MigrationDriverState;
import org.apache.kafka.metadata.migration.TopicMigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.metadata.migration.ZkMigrationState;
import org.apache.kafka.metadata.migration.ZkRecordConsumer;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.queue.KafkaEventQueue;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.util.Deadline;
import org.apache.kafka.server.util.FutureUtils;
import org.slf4j.Logger;

public class KRaftMigrationDriver
implements MetadataPublisher {
    private static final Consumer<Throwable> NO_OP_HANDLER = ex -> {};
    private static final int METADATA_COMMIT_MAX_WAIT_MS = 300000;
    private final Time time;
    private final LogContext logContext;
    private final Logger log;
    private final int nodeId;
    private final MigrationClient zkMigrationClient;
    private final KRaftMigrationZkWriter zkMetadataWriter;
    private final LegacyPropagator propagator;
    private final ZkRecordConsumer zkRecordConsumer;
    private final KafkaEventQueue eventQueue;
    private final FaultHandler faultHandler;
    private final Consumer<MetadataPublisher> initialZkLoadHandler;
    private volatile LeaderAndEpoch leaderAndEpoch;
    private volatile MigrationDriverState migrationState;
    private volatile ZkMigrationLeadershipState migrationLeadershipState;
    private volatile MetadataImage image;
    private volatile QuorumFeatures quorumFeatures;
    private volatile boolean firstPublish;

    public KRaftMigrationDriver(int nodeId, ZkRecordConsumer zkRecordConsumer, MigrationClient zkMigrationClient, LegacyPropagator propagator, Consumer<MetadataPublisher> initialZkLoadHandler, FaultHandler faultHandler, QuorumFeatures quorumFeatures, Time time) {
        this.nodeId = nodeId;
        this.zkRecordConsumer = zkRecordConsumer;
        this.zkMigrationClient = zkMigrationClient;
        this.propagator = propagator;
        this.time = time;
        this.logContext = new LogContext("[KRaftMigrationDriver id=" + nodeId + "] ");
        this.log = this.logContext.logger(KRaftMigrationDriver.class);
        this.migrationState = MigrationDriverState.UNINITIALIZED;
        this.migrationLeadershipState = ZkMigrationLeadershipState.EMPTY;
        this.eventQueue = new KafkaEventQueue(Time.SYSTEM, this.logContext, "controller-" + nodeId + "-migration-driver-");
        this.image = MetadataImage.EMPTY;
        this.firstPublish = false;
        this.leaderAndEpoch = LeaderAndEpoch.UNKNOWN;
        this.initialZkLoadHandler = initialZkLoadHandler;
        this.faultHandler = faultHandler;
        this.quorumFeatures = quorumFeatures;
        this.zkMetadataWriter = new KRaftMigrationZkWriter(zkMigrationClient);
    }

    public KRaftMigrationDriver(int nodeId, ZkRecordConsumer zkRecordConsumer, MigrationClient zkMigrationClient, LegacyPropagator propagator, Consumer<MetadataPublisher> initialZkLoadHandler, FaultHandler faultHandler, QuorumFeatures quorumFeatures) {
        this(nodeId, zkRecordConsumer, zkMigrationClient, propagator, initialZkLoadHandler, faultHandler, quorumFeatures, Time.SYSTEM);
    }

    public void start() {
        this.eventQueue.prepend((EventQueue.Event)new PollEvent());
    }

    public void shutdown() throws InterruptedException {
        this.eventQueue.beginShutdown("KRaftMigrationDriver#shutdown");
        this.log.debug("Shutting down KRaftMigrationDriver");
        this.eventQueue.close();
    }

    public CompletableFuture<MigrationDriverState> migrationState() {
        CompletableFuture<MigrationDriverState> stateFuture = new CompletableFuture<MigrationDriverState>();
        this.eventQueue.append(() -> stateFuture.complete(this.migrationState));
        return stateFuture;
    }

    private void recoverMigrationStateFromZK() {
        this.applyMigrationOperation("Recovering migration state from ZK", this.zkMigrationClient::getOrCreateMigrationRecoveryState);
        String maybeDone = this.migrationLeadershipState.initialZkMigrationComplete() ? "done" : "not done";
        this.log.info("Initial migration of ZK metadata is {}.", (Object)maybeDone);
        this.initialZkLoadHandler.accept(this);
        this.transitionTo(MigrationDriverState.INACTIVE);
    }

    private boolean isControllerQuorumReadyForMigration() {
        Optional<String> notReadyMsg = this.quorumFeatures.reasonAllControllersZkMigrationNotReady();
        if (notReadyMsg.isPresent()) {
            this.log.info("Still waiting for all controller nodes ready to begin the migration. due to:" + notReadyMsg.get());
            return false;
        }
        return true;
    }

    private boolean imageDoesNotContainAllBrokers(MetadataImage image, Set<Integer> brokerIds) {
        for (BrokerRegistration broker : image.cluster().brokers().values()) {
            if (!broker.isMigratingZkBroker()) continue;
            brokerIds.remove(broker.id());
        }
        return !brokerIds.isEmpty();
    }

    private boolean areZkBrokersReadyForMigration() {
        if (!this.firstPublish) {
            this.log.info("Waiting for initial metadata publish before checking if Zk brokers are registered.");
            return false;
        }
        if (this.image.cluster().isEmpty()) {
            this.log.info("No brokers are known to KRaft, waiting for brokers to register.");
            return false;
        }
        Set<Integer> zkBrokerRegistrations = this.zkMigrationClient.readBrokerIds();
        if (zkBrokerRegistrations.isEmpty()) {
            this.log.info("No brokers are registered in ZK, waiting for brokers to register.");
            return false;
        }
        if (this.imageDoesNotContainAllBrokers(this.image, zkBrokerRegistrations)) {
            this.log.info("Still waiting for ZK brokers {} to register with KRaft.", zkBrokerRegistrations);
            return false;
        }
        HashSet<Integer> zkBrokersWithAssignments = new HashSet<Integer>();
        this.zkMigrationClient.topicClient().iterateTopics(EnumSet.of(TopicMigrationClient.TopicVisitorInterest.TOPICS), (topicName, topicId, assignments) -> assignments.values().forEach(zkBrokersWithAssignments::addAll));
        if (this.imageDoesNotContainAllBrokers(this.image, zkBrokersWithAssignments)) {
            this.log.info("Still waiting for ZK brokers {} found in metadata to register with KRaft.", zkBrokersWithAssignments);
            return false;
        }
        return true;
    }

    private void applyMigrationOperation(String name, KRaftMigrationOperation migrationOp) {
        ZkMigrationLeadershipState beforeState = this.migrationLeadershipState;
        ZkMigrationLeadershipState afterState = migrationOp.apply(beforeState);
        if (afterState.loggableChangeSinceState(beforeState)) {
            this.log.info("{}. Transitioned migration state from {} to {}", new Object[]{name, beforeState, afterState});
        } else if (afterState.equals(beforeState)) {
            this.log.trace("{}. Kept migration state as {}", (Object)name, (Object)afterState);
        } else {
            this.log.trace("{}. Transitioned migration state from {} to {}", new Object[]{name, beforeState, afterState});
        }
        this.migrationLeadershipState = afterState;
    }

    private boolean isValidStateChange(MigrationDriverState newState) {
        if (this.migrationState == newState) {
            return true;
        }
        if (newState == MigrationDriverState.UNINITIALIZED) {
            return false;
        }
        switch (this.migrationState) {
            case UNINITIALIZED: 
            case DUAL_WRITE: {
                return newState == MigrationDriverState.INACTIVE;
            }
            case INACTIVE: {
                return newState == MigrationDriverState.WAIT_FOR_CONTROLLER_QUORUM;
            }
            case WAIT_FOR_CONTROLLER_QUORUM: {
                return newState == MigrationDriverState.INACTIVE || newState == MigrationDriverState.BECOME_CONTROLLER || newState == MigrationDriverState.WAIT_FOR_BROKERS;
            }
            case WAIT_FOR_BROKERS: {
                return newState == MigrationDriverState.INACTIVE || newState == MigrationDriverState.BECOME_CONTROLLER;
            }
            case BECOME_CONTROLLER: {
                return newState == MigrationDriverState.INACTIVE || newState == MigrationDriverState.ZK_MIGRATION || newState == MigrationDriverState.SYNC_KRAFT_TO_ZK;
            }
            case ZK_MIGRATION: {
                return newState == MigrationDriverState.INACTIVE || newState == MigrationDriverState.SYNC_KRAFT_TO_ZK;
            }
            case SYNC_KRAFT_TO_ZK: {
                return newState == MigrationDriverState.INACTIVE || newState == MigrationDriverState.KRAFT_CONTROLLER_TO_BROKER_COMM;
            }
            case KRAFT_CONTROLLER_TO_BROKER_COMM: {
                return newState == MigrationDriverState.INACTIVE || newState == MigrationDriverState.DUAL_WRITE;
            }
        }
        this.log.error("Migration driver trying to transition from an unknown state {}", (Object)this.migrationState);
        return false;
    }

    private boolean checkDriverState(MigrationDriverState expectedState) {
        if (this.migrationState.equals((Object)expectedState)) {
            return true;
        }
        this.log.info("Expected driver state {} but found {}. Not running this event {}.", new Object[]{expectedState, this.migrationState, this.getClass().getSimpleName()});
        return false;
    }

    private void transitionTo(MigrationDriverState newState) {
        if (!this.isValidStateChange(newState)) {
            throw new IllegalStateException(String.format("Invalid transition in migration driver from %s to %s", new Object[]{this.migrationState, newState}));
        }
        if (newState != this.migrationState) {
            this.log.debug("{} transitioning from {} to {} state", new Object[]{this.nodeId, this.migrationState, newState});
        } else {
            this.log.trace("{} transitioning from {} to {} state", new Object[]{this.nodeId, this.migrationState, newState});
        }
        this.migrationState = newState;
    }

    @Override
    public String name() {
        return "KRaftMigrationDriver";
    }

    @Override
    public void onControllerChange(LeaderAndEpoch newLeaderAndEpoch) {
        this.eventQueue.append((EventQueue.Event)new KRaftLeaderEvent(newLeaderAndEpoch));
    }

    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        this.enqueueMetadataChangeEvent(delta, newImage, manifest.provenance(), manifest.type() == LoaderManifestType.SNAPSHOT, NO_OP_HANDLER);
    }

    void enqueueMetadataChangeEvent(MetadataDelta delta, MetadataImage newImage, MetadataProvenance provenance, boolean isSnapshot, Consumer<Throwable> completionHandler) {
        MetadataChangeEvent metadataChangeEvent = new MetadataChangeEvent(delta, newImage, provenance, isSnapshot, completionHandler);
        this.eventQueue.append((EventQueue.Event)metadataChangeEvent);
    }

    @Override
    public void close() throws Exception {
        this.eventQueue.close();
    }

    static KRaftMigrationOperationConsumer countingOperationConsumer(Map<String, Integer> dualWriteCounts, BiConsumer<String, KRaftMigrationOperation> operationConsumer) {
        return (opType, logMsg, operation) -> {
            dualWriteCounts.compute(opType, (key, value) -> {
                if (value == null) {
                    return 1;
                }
                return value + 1;
            });
            operationConsumer.accept(logMsg, operation);
        };
    }

    static String recordBatchToString(Collection<ApiMessageAndVersion> batch) {
        String batchString = batch.stream().map(apiMessageAndVersion -> {
            if (apiMessageAndVersion.message().apiKey() == MetadataRecordType.CONFIG_RECORD.id()) {
                StringBuilder sb = new StringBuilder();
                sb.append("ApiMessageAndVersion(");
                ConfigRecord record = (ConfigRecord)apiMessageAndVersion.message();
                sb.append("ConfigRecord(");
                sb.append("resourceType=");
                sb.append(record.resourceType());
                sb.append(", resourceName=");
                sb.append(record.resourceName());
                sb.append(", name=");
                sb.append(record.name());
                sb.append(")");
                sb.append(" at version ");
                sb.append(apiMessageAndVersion.version());
                sb.append(")");
                return sb.toString();
            }
            return apiMessageAndVersion.toString();
        }).collect(Collectors.joining(","));
        return "[" + batchString + "]";
    }

    class MetadataChangeEvent
    extends MigrationEvent {
        private final MetadataDelta delta;
        private final MetadataImage image;
        private final MetadataProvenance provenance;
        private final boolean isSnapshot;
        private final Consumer<Throwable> completionHandler;

        MetadataChangeEvent(MetadataDelta delta, MetadataImage image, MetadataProvenance provenance, boolean isSnapshot, Consumer<Throwable> completionHandler) {
            this.delta = delta;
            this.image = image;
            this.provenance = provenance;
            this.isSnapshot = isSnapshot;
            this.completionHandler = completionHandler;
        }

        public void run() throws Exception {
            String metadataType;
            KRaftMigrationDriver.this.firstPublish = true;
            MetadataImage prevImage = KRaftMigrationDriver.this.image;
            KRaftMigrationDriver.this.image = this.image;
            String string = metadataType = this.isSnapshot ? "snapshot" : "delta";
            if (!KRaftMigrationDriver.this.migrationState.allowDualWrite()) {
                KRaftMigrationDriver.this.log.trace("Received metadata {}, but the controller is not in dual-write mode. Ignoring the change to be replicated to Zookeeper", (Object)metadataType);
                this.completionHandler.accept(null);
                return;
            }
            if (this.image.highestOffsetAndEpoch().compareTo(KRaftMigrationDriver.this.migrationLeadershipState.offsetAndEpoch()) < 0) {
                KRaftMigrationDriver.this.log.info("Ignoring {} {} which contains metadata that has already been written to ZK.", (Object)metadataType, (Object)this.provenance);
                this.completionHandler.accept(null);
                return;
            }
            TreeMap<String, Integer> dualWriteCounts = new TreeMap<String, Integer>();
            if (this.isSnapshot) {
                KRaftMigrationDriver.this.zkMetadataWriter.handleSnapshot(this.image, KRaftMigrationDriver.countingOperationConsumer(dualWriteCounts, (x$0, x$1) -> KRaftMigrationDriver.this.applyMigrationOperation(x$0, x$1)));
            } else {
                KRaftMigrationDriver.this.zkMetadataWriter.handleDelta(prevImage, this.image, this.delta, KRaftMigrationDriver.countingOperationConsumer(dualWriteCounts, (x$0, x$1) -> KRaftMigrationDriver.this.applyMigrationOperation(x$0, x$1)));
            }
            if (dualWriteCounts.isEmpty()) {
                KRaftMigrationDriver.this.log.trace("Did not make any ZK writes when handling KRaft {}", (Object)(this.isSnapshot ? "snapshot" : "delta"));
            } else {
                KRaftMigrationDriver.this.log.debug("Made the following ZK writes when handling KRaft {}: {}", (Object)(this.isSnapshot ? "snapshot" : "delta"), dualWriteCounts);
            }
            ZkMigrationLeadershipState zkStateAfterDualWrite = KRaftMigrationDriver.this.migrationLeadershipState.withKRaftMetadataOffsetAndEpoch(this.image.highestOffsetAndEpoch().offset(), this.image.highestOffsetAndEpoch().epoch());
            KRaftMigrationDriver.this.applyMigrationOperation("Updating ZK migration state after " + metadataType, state -> KRaftMigrationDriver.this.zkMigrationClient.setMigrationRecoveryState(zkStateAfterDualWrite));
            if (this.delta.topicsDelta() != null || this.delta.clusterDelta() != null) {
                KRaftMigrationDriver.this.log.trace("Sending RPCs to brokers for metadata {}.", (Object)metadataType);
                KRaftMigrationDriver.this.propagator.sendRPCsToBrokersFromMetadataDelta(this.delta, this.image, KRaftMigrationDriver.this.migrationLeadershipState.zkControllerEpoch());
            } else {
                KRaftMigrationDriver.this.log.trace("Not sending RPCs to brokers for metadata {} since no relevant metadata has changed", (Object)metadataType);
            }
            this.completionHandler.accept(null);
        }

        @Override
        public void handleException(Throwable e) {
            this.completionHandler.accept(e);
            super.handleException(e);
        }
    }

    class SendRPCsToBrokersEvent
    extends MigrationEvent {
        SendRPCsToBrokersEvent() {
        }

        public void run() throws Exception {
            if (KRaftMigrationDriver.this.checkDriverState(MigrationDriverState.KRAFT_CONTROLLER_TO_BROKER_COMM)) {
                if (KRaftMigrationDriver.this.image.highestOffsetAndEpoch().compareTo(KRaftMigrationDriver.this.migrationLeadershipState.offsetAndEpoch()) >= 0) {
                    KRaftMigrationDriver.this.log.trace("Sending RPCs to broker before moving to dual-write mode using at offset and epoch {}", (Object)KRaftMigrationDriver.this.image.highestOffsetAndEpoch());
                    KRaftMigrationDriver.this.propagator.sendRPCsToBrokersFromMetadataImage(KRaftMigrationDriver.this.image, KRaftMigrationDriver.this.migrationLeadershipState.zkControllerEpoch());
                    KRaftMigrationDriver.this.transitionTo(MigrationDriverState.DUAL_WRITE);
                } else {
                    KRaftMigrationDriver.this.log.trace("Ignoring using metadata image since migration leadership state is at a greater offset and epoch {}", (Object)KRaftMigrationDriver.this.migrationLeadershipState.offsetAndEpoch());
                }
            }
        }
    }

    class SyncKRaftMetadataEvent
    extends MigrationEvent {
        SyncKRaftMetadataEvent() {
        }

        public void run() throws Exception {
            if (KRaftMigrationDriver.this.checkDriverState(MigrationDriverState.SYNC_KRAFT_TO_ZK)) {
                KRaftMigrationDriver.this.log.info("Performing a full metadata sync from KRaft to ZK.");
                TreeMap<String, Integer> dualWriteCounts = new TreeMap<String, Integer>();
                KRaftMigrationDriver.this.zkMetadataWriter.handleSnapshot(KRaftMigrationDriver.this.image, KRaftMigrationDriver.countingOperationConsumer(dualWriteCounts, (x$0, x$1) -> KRaftMigrationDriver.this.applyMigrationOperation(x$0, x$1)));
                KRaftMigrationDriver.this.log.info("Made the following ZK writes when reconciling with KRaft state: {}", dualWriteCounts);
                KRaftMigrationDriver.this.transitionTo(MigrationDriverState.KRAFT_CONTROLLER_TO_BROKER_COMM);
            }
        }
    }

    class MigrateMetadataEvent
    extends MigrationEvent {
        MigrateMetadataEvent() {
        }

        public void run() throws Exception {
            if (!KRaftMigrationDriver.this.checkDriverState(MigrationDriverState.ZK_MIGRATION)) {
                return;
            }
            HashSet brokersInMetadata = new HashSet();
            KRaftMigrationDriver.this.log.info("Starting ZK migration");
            KRaftMigrationDriver.this.zkRecordConsumer.beginMigration();
            try {
                AtomicInteger count = new AtomicInteger(0);
                KRaftMigrationDriver.this.zkMigrationClient.readAllMetadata(batch -> {
                    try {
                        if (KRaftMigrationDriver.this.log.isTraceEnabled()) {
                            KRaftMigrationDriver.this.log.trace("Migrating {} records from ZK: {}", (Object)batch.size(), (Object)KRaftMigrationDriver.recordBatchToString(batch));
                        } else {
                            KRaftMigrationDriver.this.log.info("Migrating {} records from ZK", (Object)batch.size());
                        }
                        CompletableFuture<?> future = KRaftMigrationDriver.this.zkRecordConsumer.acceptBatch((List<ApiMessageAndVersion>)batch);
                        FutureUtils.waitWithLogging((Logger)KRaftMigrationDriver.this.log, (String)"", (String)"the metadata layer to commit migration record batch", future, (Deadline)Deadline.fromDelay((Time)KRaftMigrationDriver.this.time, (long)300000L, (TimeUnit)TimeUnit.MILLISECONDS), (Time)KRaftMigrationDriver.this.time);
                        count.addAndGet(batch.size());
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }, brokersInMetadata::add);
                CompletableFuture<OffsetAndEpoch> completeMigrationFuture = KRaftMigrationDriver.this.zkRecordConsumer.completeMigration();
                OffsetAndEpoch offsetAndEpochAfterMigration = (OffsetAndEpoch)FutureUtils.waitWithLogging((Logger)KRaftMigrationDriver.this.log, (String)"", (String)"the metadata layer to complete the migration", completeMigrationFuture, (Deadline)Deadline.fromDelay((Time)KRaftMigrationDriver.this.time, (long)300000L, (TimeUnit)TimeUnit.MILLISECONDS), (Time)KRaftMigrationDriver.this.time);
                KRaftMigrationDriver.this.log.info("Completed migration of metadata from Zookeeper to KRaft. A total of {} metadata records were generated. The current metadata offset is now {} with an epoch of {}. Saw {} brokers in the migrated metadata {}.", new Object[]{count.get(), offsetAndEpochAfterMigration.offset(), offsetAndEpochAfterMigration.epoch(), brokersInMetadata.size(), brokersInMetadata});
                ZkMigrationLeadershipState newState = KRaftMigrationDriver.this.migrationLeadershipState.withKRaftMetadataOffsetAndEpoch(offsetAndEpochAfterMigration.offset(), offsetAndEpochAfterMigration.epoch());
                KRaftMigrationDriver.this.applyMigrationOperation("Finished initial migration of ZK metadata to KRaft", state -> KRaftMigrationDriver.this.zkMigrationClient.setMigrationRecoveryState(newState));
                KRaftMigrationDriver.this.transitionTo(MigrationDriverState.SYNC_KRAFT_TO_ZK);
            }
            catch (Throwable t) {
                KRaftMigrationDriver.this.zkRecordConsumer.abortMigration();
                super.handleException(t);
            }
        }
    }

    class WaitForZkBrokersEvent
    extends MigrationEvent {
        WaitForZkBrokersEvent() {
        }

        public void run() throws Exception {
            if (KRaftMigrationDriver.this.checkDriverState(MigrationDriverState.WAIT_FOR_BROKERS) && KRaftMigrationDriver.this.areZkBrokersReadyForMigration()) {
                KRaftMigrationDriver.this.log.debug("Zk brokers are registered and ready for migration");
                KRaftMigrationDriver.this.transitionTo(MigrationDriverState.BECOME_CONTROLLER);
            }
        }
    }

    class BecomeZkControllerEvent
    extends MigrationEvent {
        BecomeZkControllerEvent() {
        }

        public void run() throws Exception {
            if (KRaftMigrationDriver.this.checkDriverState(MigrationDriverState.BECOME_CONTROLLER)) {
                KRaftMigrationDriver.this.applyMigrationOperation("Claiming ZK controller leadership", KRaftMigrationDriver.this.zkMigrationClient::claimControllerLeadership);
                if (KRaftMigrationDriver.this.migrationLeadershipState.zkControllerEpochZkVersion() == -1) {
                    KRaftMigrationDriver.this.log.debug("Unable to claim leadership, will retry until we learn of a different KRaft leader");
                } else if (!KRaftMigrationDriver.this.migrationLeadershipState.initialZkMigrationComplete()) {
                    KRaftMigrationDriver.this.transitionTo(MigrationDriverState.ZK_MIGRATION);
                } else {
                    KRaftMigrationDriver.this.transitionTo(MigrationDriverState.SYNC_KRAFT_TO_ZK);
                }
            }
        }
    }

    class WaitForControllerQuorumEvent
    extends MigrationEvent {
        WaitForControllerQuorumEvent() {
        }

        public void run() throws Exception {
            if (KRaftMigrationDriver.this.checkDriverState(MigrationDriverState.WAIT_FOR_CONTROLLER_QUORUM)) {
                if (!KRaftMigrationDriver.this.firstPublish) {
                    KRaftMigrationDriver.this.log.trace("Waiting until we have received metadata before proceeding with migration");
                    return;
                }
                ZkMigrationState zkMigrationState = KRaftMigrationDriver.this.image.features().zkMigrationState();
                switch (zkMigrationState) {
                    case NONE: {
                        KRaftMigrationDriver.this.log.error("The controller's ZkMigrationState is NONE which means this cluster should not be migrated from ZooKeeper. This controller should not be configured with 'zookeeper.metadata.migration.enable' set to true. Will not proceed with a migration.");
                        KRaftMigrationDriver.this.transitionTo(MigrationDriverState.INACTIVE);
                        break;
                    }
                    case PRE_MIGRATION: {
                        if (!KRaftMigrationDriver.this.isControllerQuorumReadyForMigration()) break;
                        KRaftMigrationDriver.this.log.debug("Controller Quorum is ready for Zk to KRaft migration. Now waiting for ZK brokers.");
                        KRaftMigrationDriver.this.transitionTo(MigrationDriverState.WAIT_FOR_BROKERS);
                        break;
                    }
                    case MIGRATION: {
                        if (!KRaftMigrationDriver.this.migrationLeadershipState.initialZkMigrationComplete()) {
                            KRaftMigrationDriver.this.log.error("KRaft controller indicates an active migration, but the ZK state does not.");
                            KRaftMigrationDriver.this.transitionTo(MigrationDriverState.INACTIVE);
                            break;
                        }
                        KRaftMigrationDriver.this.log.debug("Migration is in already progress, not waiting on ZK brokers.");
                        KRaftMigrationDriver.this.transitionTo(MigrationDriverState.BECOME_CONTROLLER);
                        break;
                    }
                    case POST_MIGRATION: {
                        KRaftMigrationDriver.this.log.error("KRaft controller indicates a completed migration, but the migration driver is somehow active.");
                        KRaftMigrationDriver.this.transitionTo(MigrationDriverState.INACTIVE);
                    }
                }
            }
        }
    }

    class KRaftLeaderEvent
    extends MigrationEvent {
        private final LeaderAndEpoch leaderAndEpoch;

        KRaftLeaderEvent(LeaderAndEpoch leaderAndEpoch) {
            this.leaderAndEpoch = leaderAndEpoch;
        }

        public void run() throws Exception {
            KRaftMigrationDriver.this.leaderAndEpoch = this.leaderAndEpoch;
            boolean isActive = this.leaderAndEpoch.isLeader(KRaftMigrationDriver.this.nodeId);
            if (!isActive) {
                KRaftMigrationDriver.this.applyMigrationOperation("Became inactive migration driver", state -> state.withNewKRaftController(this.leaderAndEpoch.leaderId().orElse(ZkMigrationLeadershipState.EMPTY.kraftControllerId()), this.leaderAndEpoch.epoch()));
                KRaftMigrationDriver.this.transitionTo(MigrationDriverState.INACTIVE);
            } else {
                KRaftMigrationDriver.this.applyMigrationOperation("Became active migration driver", state -> {
                    ZkMigrationLeadershipState recoveredState = KRaftMigrationDriver.this.zkMigrationClient.getOrCreateMigrationRecoveryState(state);
                    return recoveredState.withNewKRaftController(KRaftMigrationDriver.this.nodeId, this.leaderAndEpoch.epoch());
                });
                KRaftMigrationDriver.this.transitionTo(MigrationDriverState.WAIT_FOR_CONTROLLER_QUORUM);
            }
        }
    }

    class PollEvent
    extends MigrationEvent {
        PollEvent() {
        }

        public void run() throws Exception {
            switch (KRaftMigrationDriver.this.migrationState) {
                case UNINITIALIZED: {
                    KRaftMigrationDriver.this.recoverMigrationStateFromZK();
                    break;
                }
                case INACTIVE: {
                    break;
                }
                case WAIT_FOR_CONTROLLER_QUORUM: {
                    KRaftMigrationDriver.this.eventQueue.append((EventQueue.Event)new WaitForControllerQuorumEvent());
                    break;
                }
                case BECOME_CONTROLLER: {
                    KRaftMigrationDriver.this.eventQueue.append((EventQueue.Event)new BecomeZkControllerEvent());
                    break;
                }
                case WAIT_FOR_BROKERS: {
                    KRaftMigrationDriver.this.eventQueue.append((EventQueue.Event)new WaitForZkBrokersEvent());
                    break;
                }
                case ZK_MIGRATION: {
                    KRaftMigrationDriver.this.eventQueue.append((EventQueue.Event)new MigrateMetadataEvent());
                    break;
                }
                case SYNC_KRAFT_TO_ZK: {
                    KRaftMigrationDriver.this.eventQueue.append((EventQueue.Event)new SyncKRaftMetadataEvent());
                    break;
                }
                case KRAFT_CONTROLLER_TO_BROKER_COMM: {
                    KRaftMigrationDriver.this.eventQueue.append((EventQueue.Event)new SendRPCsToBrokersEvent());
                    break;
                }
            }
            long deadline = KRaftMigrationDriver.this.time.nanoseconds() + TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
            KRaftMigrationDriver.this.eventQueue.scheduleDeferred("poll", (Function)new EventQueue.DeadlineFunction(deadline), (EventQueue.Event)new PollEvent());
        }
    }

    abstract class MigrationEvent
    implements EventQueue.Event {
        MigrationEvent() {
        }

        public void handleException(Throwable e) {
            if (e instanceof MigrationClientAuthException) {
                KRaftMigrationDriver.this.faultHandler.handleFault("Encountered ZooKeeper authentication in " + this, e);
            } else if (e instanceof MigrationClientException) {
                KRaftMigrationDriver.this.log.info(String.format("Encountered ZooKeeper error during event %s. Will retry.", this), e.getCause());
            } else if (e instanceof RejectedExecutionException) {
                KRaftMigrationDriver.this.log.debug("Not processing {} because the event queue is closed.", (Object)this);
            } else {
                KRaftMigrationDriver.this.faultHandler.handleFault("Unhandled error in " + this, e);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

