/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaUtils;
import io.confluent.kafka.schemaregistry.json.SpecificationVersion;
import io.confluent.kafka.schemaregistry.utils.BoundedConcurrentHashMap;
import io.confluent.kafka.serializers.json.AbstractKafkaJsonSchemaSerializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaSerializerConfig;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaJsonSchemaSerializer<T>
extends AbstractKafkaJsonSchemaSerializer<T>
implements Serializer<T> {
    private static int DEFAULT_CACHE_CAPACITY = 1000;
    private boolean isKey;
    private Map<ObjectNode, JsonSchema> nodeToSchemaCache;
    private Map<Class<?>, JsonSchema> classToSchemaCache;

    public KafkaJsonSchemaSerializer() {
        this.nodeToSchemaCache = new BoundedConcurrentHashMap(DEFAULT_CACHE_CAPACITY);
        this.classToSchemaCache = new BoundedConcurrentHashMap(DEFAULT_CACHE_CAPACITY);
    }

    public KafkaJsonSchemaSerializer(SchemaRegistryClient client) {
        this.schemaRegistry = client;
        this.ticker = this.ticker(client);
        this.nodeToSchemaCache = new BoundedConcurrentHashMap(DEFAULT_CACHE_CAPACITY);
        this.classToSchemaCache = new BoundedConcurrentHashMap(DEFAULT_CACHE_CAPACITY);
    }

    public KafkaJsonSchemaSerializer(SchemaRegistryClient client, Map<String, ?> props) {
        this(client, props, DEFAULT_CACHE_CAPACITY);
    }

    public KafkaJsonSchemaSerializer(SchemaRegistryClient client, Map<String, ?> props, int cacheCapacity) {
        this.schemaRegistry = client;
        this.ticker = this.ticker(client);
        this.configure(this.serializerConfig(props));
        this.nodeToSchemaCache = new BoundedConcurrentHashMap(cacheCapacity);
        this.classToSchemaCache = new BoundedConcurrentHashMap(cacheCapacity);
    }

    public void configure(Map<String, ?> config, boolean isKey) {
        this.isKey = isKey;
        this.configure(new KafkaJsonSchemaSerializerConfig(config));
    }

    public byte[] serialize(String topic, T record) {
        return this.serialize(topic, null, record);
    }

    public byte[] serialize(String topic, Headers headers, T record) {
        if (record == null) {
            return null;
        }
        JsonSchema schema = JsonSchemaUtils.isEnvelope(record) ? this.nodeToSchemaCache.computeIfAbsent(JsonSchemaUtils.copyEnvelopeWithoutPayload((ObjectNode)((ObjectNode)record)), k -> this.getSchema(record)) : this.classToSchemaCache.computeIfAbsent(record.getClass(), k -> this.getSchema(record));
        Object value = JsonSchemaUtils.getValue(record);
        return this.serializeImpl(this.getSubjectName(topic, this.isKey, value, (ParsedSchema)schema), topic, headers, value, schema);
    }

    private JsonSchema getSchema(T record) {
        try {
            return JsonSchemaUtils.getSchema(record, (SpecificationVersion)this.specVersion, (List)this.scanPackages, (boolean)this.oneofForNullables, (boolean)this.failUnknownProperties, (ObjectMapper)this.objectMapper, (SchemaRegistryClient)this.schemaRegistry);
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public void close() {
        try {
            super.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while closing serializer", e);
        }
    }
}

