/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.ZkSecurityMigrator;
import kafka.server.KafkaConfig$;
import kafka.utils.Exit$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.ToolsUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.zookeeper.client.ZKClientConfig;
import scala.Function0;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class ZkSecurityMigrator$
implements Logging {
    public static final ZkSecurityMigrator$ MODULE$ = new ZkSecurityMigrator$();
    private static final String usageMessage = "ZooKeeper Migration Tool Help. This tool updates the ACLs of znodes as part of the process of setting up ZooKeeper authentication.";
    private static final String tlsConfigFileOption = "zk-tls-config-file";
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public String usageMessage() {
        return usageMessage;
    }

    public String tlsConfigFileOption() {
        return tlsConfigFileOption;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void run(String[] args) {
        boolean bl;
        ZKClientConfig zkClientConfig;
        ZkSecurityMigrator.ZkSecurityMigratorOptions opts;
        block8: {
            String jaasFile = System.getProperty("java.security.auth.login.config");
            opts = new ZkSecurityMigrator.ZkSecurityMigratorOptions(args);
            CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)opts, (String)this.usageMessage());
            zkClientConfig = (ZKClientConfig)this.createZkClientConfigFromOption(opts.options, opts.zkTlsConfigFile()).getOrElse((Function0 & Serializable)() -> new ZKClientConfig());
            boolean tlsClientAuthEnabled = KafkaConfig$.MODULE$.zkTlsClientAuthEnabled(zkClientConfig);
            if (jaasFile == null && !tlsClientAuthEnabled) {
                String errorMsg = new StringBuilder(273).append("No JAAS configuration file has been specified and no TLS client certificate has been specified. Please make sure that you set ").append("the system property ").append("java.security.auth.login.config").append(" or provide a ZooKeeper client TLS configuration via --").append(this.tlsConfigFileOption()).append(" <filename> ").append("identifying at least ").append(KafkaConfig$.MODULE$.ZkSslClientEnableProp()).append(", ").append(KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()).append(", and ").append(KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()).toString();
                System.err.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("ERROR: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{errorMsg})));
                throw new IllegalArgumentException("Incorrect configuration");
            }
            if (!tlsClientAuthEnabled && !JaasUtils.isZkSaslEnabled()) {
                String errorMsg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Security isn't enabled, most likely the file isn't set properly: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{jaasFile}));
                System.out.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("ERROR: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{errorMsg})));
                throw new IllegalArgumentException("Incorrect configuration");
            }
            String string = (String)opts.options.valueOf(opts.zkAclOpt());
            switch (string == null ? 0 : string.hashCode()) {
                case -906273929: {
                    if (!"secure".equals(string)) break;
                    if (this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = "zookeeper.acl option is secure";
                        Object var19_9 = null;
                        this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                    }
                    bl = true;
                    break block8;
                }
                case -19770544: {
                    if (!"unsecure".equals(string)) break;
                    if (this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = "zookeeper.acl option is unsecure";
                        Object var20_10 = null;
                        this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                    }
                    bl = false;
                    break block8;
                }
            }
            throw ToolsUtils$.MODULE$.printUsageAndExit(opts.parser, this.usageMessage());
        }
        boolean zkAcl = bl;
        String zkUrl = (String)opts.options.valueOf(opts.zkUrlOpt());
        int zkSessionTimeout = (Integer)opts.options.valueOf(opts.zkSessionTimeoutOpt());
        int zkConnectionTimeout = (Integer)opts.options.valueOf(opts.zkConnectionTimeoutOpt());
        Time x$6 = Time.SYSTEM;
        String x$9 = "kafka.server";
        String x$10 = "SessionExpireListener";
        boolean x$11 = false;
        KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkUrl, zkAcl, zkSessionTimeout, zkConnectionTimeout, Integer.MAX_VALUE, x$6, "ZkSecurityMigrator", zkClientConfig, x$9, x$10, x$11);
        boolean enablePathCheck = opts.options.has((OptionSpec)opts.enablePathCheckOpt());
        new ZkSecurityMigrator(zkClient).kafka$admin$ZkSecurityMigrator$$run(enablePathCheck);
    }

    public void main(String[] args) {
        try {
            this.run(args);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
        }
    }

    public ZKClientConfig createZkClientConfigFromFile(String filename) {
        Properties zkTlsConfigFileProps = Utils.loadProps((String)filename, (List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().toList()).asJava());
        ZKClientConfig zkClientConfig = new ZKClientConfig();
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = ZkSecurityMigrator$.$anonfun$createZkClientConfigFromFile$1(zkTlsConfigFileProps, filename);
            Object var4_4 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        CollectionConverters$.MODULE$.PropertiesHasAsScala(zkTlsConfigFileProps).asScala().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(key, value) -> {
            ZkSecurityMigrator$.$anonfun$createZkClientConfigFromFile$2(zkClientConfig, key, value);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        return zkClientConfig;
    }

    public Option<ZKClientConfig> createZkClientConfigFromOption(OptionSet options, ArgumentAcceptingOptionSpec<String> option) {
        if (!options.has(option)) {
            return None$.MODULE$;
        }
        return new Some((Object)this.createZkClientConfigFromFile((String)options.valueOf(option)));
    }

    public static final /* synthetic */ String $anonfun$run$2() {
        return "zookeeper.acl option is secure";
    }

    public static final /* synthetic */ String $anonfun$run$3() {
        return "zookeeper.acl option is unsecure";
    }

    public static final /* synthetic */ String $anonfun$createZkClientConfigFromFile$1(Properties zkTlsConfigFileProps$1, String filename$1) {
        return new StringBuilder(57).append("Found ").append(zkTlsConfigFileProps$1.size()).append(" ZooKeeper client configuration properties in file ").append(filename$1).toString();
    }

    public static final /* synthetic */ String $anonfun$createZkClientConfigFromFile$3(String key$1) {
        return new StringBuilder(8).append("Setting ").append(key$1).toString();
    }

    public static final /* synthetic */ void $anonfun$createZkClientConfigFromFile$2(ZKClientConfig zkClientConfig$1, String key, String value) {
        ZkSecurityMigrator$ info_this = MODULE$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = ZkSecurityMigrator$.$anonfun$createZkClientConfigFromFile$3(key);
            Object var4_4 = null;
            info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
        }
        Object var3_3 = null;
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(zkClientConfig$1, key, value);
    }

    private ZkSecurityMigrator$() {
    }
}

