/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.schema;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.erosb.jsonsKema.AdditionalPropertiesSchema;
import com.github.erosb.jsonsKema.AllOfSchema;
import com.github.erosb.jsonsKema.AnyOfSchema;
import com.github.erosb.jsonsKema.CompositeSchema;
import com.github.erosb.jsonsKema.ConstSchema;
import com.github.erosb.jsonsKema.ContainsSchema;
import com.github.erosb.jsonsKema.DependentRequiredSchema;
import com.github.erosb.jsonsKema.DependentSchemasSchema;
import com.github.erosb.jsonsKema.ExclusiveMaximumSchema;
import com.github.erosb.jsonsKema.ExclusiveMinimumSchema;
import com.github.erosb.jsonsKema.FormatSchema;
import com.github.erosb.jsonsKema.IJsonArray;
import com.github.erosb.jsonsKema.IJsonBoolean;
import com.github.erosb.jsonsKema.IJsonNull;
import com.github.erosb.jsonsKema.IJsonNumber;
import com.github.erosb.jsonsKema.IJsonObject;
import com.github.erosb.jsonsKema.IJsonString;
import com.github.erosb.jsonsKema.IJsonValue;
import com.github.erosb.jsonsKema.IfThenElseSchema;
import com.github.erosb.jsonsKema.ItemsSchema;
import com.github.erosb.jsonsKema.JsonArray;
import com.github.erosb.jsonsKema.JsonBoolean;
import com.github.erosb.jsonsKema.JsonNull;
import com.github.erosb.jsonsKema.JsonNumber;
import com.github.erosb.jsonsKema.JsonString;
import com.github.erosb.jsonsKema.JsonVisitor;
import com.github.erosb.jsonsKema.MaxItemsSchema;
import com.github.erosb.jsonsKema.MaxLengthSchema;
import com.github.erosb.jsonsKema.MaxPropertiesSchema;
import com.github.erosb.jsonsKema.MaximumSchema;
import com.github.erosb.jsonsKema.MinItemsSchema;
import com.github.erosb.jsonsKema.MinLengthSchema;
import com.github.erosb.jsonsKema.MinPropertiesSchema;
import com.github.erosb.jsonsKema.MinimumSchema;
import com.github.erosb.jsonsKema.MultiTypeSchema;
import com.github.erosb.jsonsKema.MultipleOfSchema;
import com.github.erosb.jsonsKema.OneOfSchema;
import com.github.erosb.jsonsKema.PatternSchema;
import com.github.erosb.jsonsKema.PrefixItemsSchema;
import com.github.erosb.jsonsKema.PropertyNamesSchema;
import com.github.erosb.jsonsKema.ReadOnlySchema;
import com.github.erosb.jsonsKema.ReferenceSchema;
import com.github.erosb.jsonsKema.Regexp;
import com.github.erosb.jsonsKema.RequiredSchema;
import com.github.erosb.jsonsKema.Schema;
import com.github.erosb.jsonsKema.SchemaVisitor;
import com.github.erosb.jsonsKema.TypeSchema;
import com.github.erosb.jsonsKema.UnevaluatedItemsSchema;
import com.github.erosb.jsonsKema.UnevaluatedPropertiesSchema;
import com.github.erosb.jsonsKema.UniqueItemsSchema;
import com.github.erosb.jsonsKema.WriteOnlySchema;
import io.confluent.kafka.schemaregistry.json.jackson.Jackson;
import io.confluent.kafka.schemaregistry.json.schema.SchemaUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Pair;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.ConditionalSchema;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.NotSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.TrueSchema;
import org.everit.json.schema.loader.OrgJsonUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class SchemaTranslator
extends SchemaVisitor<SchemaContext> {
    private static final Object NONE_MARKER = new Object();
    private static final ObjectMapper objectMapper = Jackson.newObjectMapper();
    private final Map<Schema, Schema.Builder<?>> schemaMapping = new IdentityHashMap();
    private final Deque<Pair<org.everit.json.schema.ReferenceSchema, Schema>> refMapping = new ArrayDeque<Pair<org.everit.json.schema.ReferenceSchema, Schema>>();

    public SchemaContext accumulate(Schema parent, SchemaContext previous, SchemaContext current) {
        if (previous == null) {
            return current;
        }
        if (current == null) {
            return previous;
        }
        return previous.join(parent, current);
    }

    public SchemaContext identity(Schema parent) {
        if (parent instanceof AllOfSchema) {
            return new SchemaContext(parent, (Schema.Builder<?>)CombinedSchema.allOf(Collections.emptyList()));
        }
        if (parent instanceof AnyOfSchema) {
            return new SchemaContext(parent, (Schema.Builder<?>)CombinedSchema.anyOf(Collections.emptyList()));
        }
        if (parent instanceof OneOfSchema) {
            return new SchemaContext(parent, (Schema.Builder<?>)CombinedSchema.oneOf(Collections.emptyList()));
        }
        return (SchemaContext)super.identity(parent);
    }

    public SchemaContext visitAdditionalPropertiesSchema(AdditionalPropertiesSchema schema) {
        SchemaContext ctx = (SchemaContext)super.visitAdditionalPropertiesSchema(schema);
        assert (ctx != null);
        ObjectSchema.Builder builder = ObjectSchema.builder().requiresObject(false);
        if (ctx.schemaBuilder() instanceof FalseSchema.Builder) {
            builder.additionalProperties(false);
        } else if (!(ctx.schemaBuilder() instanceof TrueSchema.Builder)) {
            builder.schemaOfAdditionalProperties(ctx.schema());
        }
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)builder);
    }

    public SchemaContext visitAllOfSchema(AllOfSchema schema) {
        return (SchemaContext)super.visitAllOfSchema(schema);
    }

    public SchemaContext visitAnyOfSchema(AnyOfSchema schema) {
        return (SchemaContext)super.visitAnyOfSchema(schema);
    }

    public SchemaContext visitChildren(Schema parent) {
        SchemaContext ctx = (SchemaContext)super.visitChildren(parent);
        return ctx != null ? ctx : new SchemaContext(parent, (Schema.Builder<?>)CombinedSchema.allOf(Collections.emptyList()).isSynthetic(true));
    }

    public SchemaContext visitCompositeSchema(CompositeSchema schema) {
        SchemaContext ctx = (SchemaContext)super.visitCompositeSchema(schema);
        if (ctx == null) {
            return new SchemaContext((Schema)schema, (Schema.Builder<?>)CombinedSchema.allOf(Collections.emptyList()).isSynthetic(true));
        }
        org.everit.json.schema.Schema ctxSchema = ctx.schema();
        if (SchemaUtils.isSyntheticAll(ctxSchema)) {
            CombinedSchema combinedSchema = (CombinedSchema)ctxSchema;
            if (combinedSchema.getSubschemas().isEmpty()) {
                ctx = new SchemaContext(ctx.source(), (Schema.Builder<?>)EmptySchema.builder());
            } else if (combinedSchema.getSubschemas().size() == 1) {
                ctx = new SchemaContext(ctx.source(), SchemaUtils.schemaToBuilder((org.everit.json.schema.Schema)combinedSchema.getSubschemas().iterator().next()));
            }
        }
        if (SchemaUtils.isSyntheticAny(ctxSchema)) {
            ((CombinedSchema.Builder)ctx.schemaBuilder()).isSynthetic(false);
        }
        if (schema.getId() != null) {
            ctx.schemaBuilder().id(schema.getId().getValue());
        }
        if (schema.getTitle() != null) {
            ctx.schemaBuilder().title(schema.getTitle().getValue());
        }
        if (schema.getDescription() != null) {
            ctx.schemaBuilder().description(schema.getDescription().getValue());
        }
        if (schema.getDefault() != null) {
            ctx.schemaBuilder().defaultValue(schema.getDefault().accept((JsonVisitor)new JsonValueVisitor()));
        }
        HashMap<String, Object> unprocessed = new HashMap<String, Object>();
        if (!schema.getUnprocessedProperties().isEmpty()) {
            for (Map.Entry entry : schema.getUnprocessedProperties().entrySet()) {
                String key = ((IJsonString)entry.getKey()).getValue();
                IJsonValue value = (IJsonValue)entry.getValue();
                Object primitiveValue = NONE_MARKER;
                if (value instanceof JsonBoolean) {
                    primitiveValue = ((JsonBoolean)value).getValue();
                } else if (value instanceof JsonNull) {
                    primitiveValue = null;
                } else if (value instanceof JsonNumber) {
                    primitiveValue = ((JsonNumber)value).getValue();
                } else if (value instanceof JsonString) {
                    primitiveValue = ((JsonString)value).getValue();
                }
                if (primitiveValue != NONE_MARKER) {
                    unprocessed.put(key, primitiveValue);
                    continue;
                }
                if (value instanceof JsonArray) {
                    unprocessed.put(key, OrgJsonUtil.toList((JSONArray)((JSONArray)objectMapper.convertValue((Object)value, JSONArray.class))));
                    continue;
                }
                unprocessed.put(key, OrgJsonUtil.toMap((JSONObject)((JSONObject)objectMapper.convertValue((Object)value, JSONObject.class))));
            }
        }
        if (!schema.getDefinedSubschemas().isEmpty()) {
            HashMap<String, org.everit.json.schema.Schema> defs = new HashMap<String, org.everit.json.schema.Schema>();
            for (Map.Entry entry : schema.getDefinedSubschemas().entrySet()) {
                String defName = (String)entry.getKey();
                Schema subschema = (Schema)entry.getValue();
                SchemaContext subctx = (SchemaContext)subschema.accept((SchemaVisitor)new SchemaTranslator());
                subctx.close();
                defs.put(defName, subctx.schema());
            }
            unprocessed.put("$defs", defs);
        }
        if (!unprocessed.isEmpty()) {
            ctx.schemaBuilder().unprocessedProperties(unprocessed);
        }
        return ctx;
    }

    public SchemaContext visitConstSchema(ConstSchema schema) {
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)org.everit.json.schema.ConstSchema.builder().permittedValue(schema.getConstant().accept((JsonVisitor)new JsonValueVisitor())));
    }

    public SchemaContext visitContainsSchema(ContainsSchema schema) {
        SchemaContext ctx = (SchemaContext)super.visitContainsSchema(schema);
        assert (ctx != null);
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)ArraySchema.builder().requiresArray(false).containsItemSchema(ctx.schema()));
    }

    public SchemaContext visitDependentRequiredSchema(DependentRequiredSchema schema) {
        ObjectSchema.Builder builder = ObjectSchema.builder().requiresObject(false);
        for (Map.Entry entry : schema.getDependentRequired().entrySet()) {
            for (String s : (List)entry.getValue()) {
                builder.propertyDependency((String)entry.getKey(), s);
            }
        }
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)builder);
    }

    public SchemaContext visitDependentSchemas(DependentSchemasSchema schema) {
        ObjectSchema.Builder builder = ObjectSchema.builder().requiresObject(false);
        for (Map.Entry entry : schema.getDependentSchemas().entrySet()) {
            SchemaContext ctx = (SchemaContext)((Schema)entry.getValue()).accept((SchemaVisitor)this);
            assert (ctx != null);
            builder.schemaDependency((String)entry.getKey(), ctx.schema());
        }
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)builder);
    }

    public SchemaContext visitEnumSchema(com.github.erosb.jsonsKema.EnumSchema schema) {
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)EnumSchema.builder().possibleValues(schema.getPotentialValues().stream().map(v -> v.accept((JsonVisitor)new JsonValueVisitor())).collect(Collectors.toList())));
    }

    public SchemaContext visitExclusiveMaximumSchema(ExclusiveMaximumSchema schema) {
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)NumberSchema.builder().requiresNumber(false).exclusiveMaximum(schema.getMaximum()));
    }

    public SchemaContext visitExclusiveMinimumSchema(ExclusiveMinimumSchema schema) {
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)NumberSchema.builder().requiresNumber(false).exclusiveMinimum(schema.getMinimum()));
    }

    public SchemaContext visitFalseSchema(com.github.erosb.jsonsKema.FalseSchema schema) {
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)FalseSchema.builder());
    }

    public SchemaContext visitFormatSchema(FormatSchema schema) {
        return (SchemaContext)super.visitFormatSchema(schema);
    }

    public SchemaContext visitIfThenElseSchema(IfThenElseSchema schema) {
        org.everit.json.schema.Schema ifSchema = null;
        if (schema.getIfSchema() != null) {
            SchemaContext ctx = (SchemaContext)schema.getIfSchema().accept((SchemaVisitor)this);
            assert (ctx != null);
            ifSchema = ctx.schema();
        }
        org.everit.json.schema.Schema thenSchema = null;
        if (schema.getThenSchema() != null) {
            SchemaContext ctx = (SchemaContext)schema.getThenSchema().accept((SchemaVisitor)this);
            assert (ctx != null);
            thenSchema = ctx.schema();
        }
        org.everit.json.schema.Schema elseSchema = null;
        if (schema.getElseSchema() != null) {
            SchemaContext ctx = (SchemaContext)schema.getElseSchema().accept((SchemaVisitor)this);
            assert (ctx != null);
            elseSchema = ctx.schema();
        }
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)ConditionalSchema.builder().ifSchema(ifSchema).thenSchema(thenSchema).elseSchema(elseSchema));
    }

    public SchemaContext visitItemsSchema(ItemsSchema schema) {
        SchemaContext ctx = (SchemaContext)super.visitItemsSchema(schema);
        assert (ctx != null);
        ArraySchema.Builder builder = ArraySchema.builder().requiresArray(false);
        if (ctx.schemaBuilder() instanceof FalseSchema.Builder) {
            builder.additionalItems(false);
        } else if (!(ctx.schemaBuilder() instanceof TrueSchema.Builder)) {
            if (schema.getPrefixItemCount() == 0) {
                builder.allItemSchema(ctx.schema());
            } else {
                builder.schemaOfAdditionalItems(ctx.schema());
            }
        }
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)builder);
    }

    public SchemaContext visitMaxItemsSchema(MaxItemsSchema schema) {
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)ArraySchema.builder().requiresArray(false).maxItems(Integer.valueOf(schema.getMaxItems().intValue())));
    }

    public SchemaContext visitMaxLengthSchema(MaxLengthSchema schema) {
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)StringSchema.builder().requiresString(false).maxLength(Integer.valueOf(schema.getMaxLength())));
    }

    public SchemaContext visitMaxPropertiesSchema(MaxPropertiesSchema schema) {
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)ObjectSchema.builder().requiresObject(false).maxProperties(Integer.valueOf(schema.getMaxProperties().intValue())));
    }

    public SchemaContext visitMaximumSchema(MaximumSchema schema) {
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)NumberSchema.builder().requiresNumber(false).maximum(schema.getMaximum()));
    }

    public SchemaContext visitMinItemsSchema(MinItemsSchema schema) {
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)ArraySchema.builder().requiresArray(false).minItems(Integer.valueOf(schema.getMinItems().intValue())));
    }

    public SchemaContext visitMinLengthSchema(MinLengthSchema schema) {
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)StringSchema.builder().requiresString(false).minLength(Integer.valueOf(schema.getMinLength())));
    }

    public SchemaContext visitMinPropertiesSchema(MinPropertiesSchema schema) {
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)ObjectSchema.builder().requiresObject(false).minProperties(Integer.valueOf(schema.getMinProperties().intValue())));
    }

    public SchemaContext visitMinimumSchema(MinimumSchema schema) {
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)NumberSchema.builder().requiresNumber(false).minimum(schema.getMinimum()));
    }

    public SchemaContext visitMultiTypeSchema(MultiTypeSchema schema) {
        List schemas = schema.getTypes().getElements().stream().map(json -> this.typeToSchema(json.requireString().getValue()).build()).collect(Collectors.toList());
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)CombinedSchema.anyOf(schemas).isSynthetic(true));
    }

    public SchemaContext visitMultipleOfSchema(MultipleOfSchema schema) {
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)NumberSchema.builder().requiresNumber(false).multipleOf(schema.getDenominator()));
    }

    public SchemaContext visitNotSchema(com.github.erosb.jsonsKema.NotSchema schema) {
        SchemaContext ctx = (SchemaContext)super.visitNotSchema(schema);
        assert (ctx != null);
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)NotSchema.builder().mustNotMatch(ctx.schema()));
    }

    public SchemaContext visitOneOfSchema(OneOfSchema schema) {
        return (SchemaContext)super.visitOneOfSchema(schema);
    }

    public SchemaContext visitPatternPropertySchema(Regexp pattern, Schema schema) {
        SchemaContext ctx = (SchemaContext)schema.accept((SchemaVisitor)this);
        assert (ctx != null);
        return new SchemaContext(schema, (Schema.Builder<?>)ObjectSchema.builder().requiresObject(false).patternProperty(pattern.toString(), ctx.schema()));
    }

    public SchemaContext visitPatternSchema(PatternSchema schema) {
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)StringSchema.builder().requiresString(false).pattern(schema.getPattern().toString()));
    }

    public SchemaContext visitPrefixItemsSchema(PrefixItemsSchema schema) {
        ArraySchema.Builder builder = ArraySchema.builder().requiresArray(false);
        for (Schema s : schema.getPrefixSchemas()) {
            SchemaContext ctx = (SchemaContext)s.accept((SchemaVisitor)this);
            assert (ctx != null);
            builder.addItemSchema(ctx.schema());
        }
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)builder);
    }

    public SchemaContext visitPropertyNamesSchema(PropertyNamesSchema propertyNamesSchema) {
        SchemaContext ctx = (SchemaContext)super.visitPropertyNamesSchema(propertyNamesSchema);
        assert (ctx != null);
        return new SchemaContext((Schema)propertyNamesSchema, (Schema.Builder<?>)ObjectSchema.builder().requiresObject(false).propertyNameSchema(ctx.schema()));
    }

    public SchemaContext visitPropertySchema(String property, Schema schema) {
        SchemaContext ctx = (SchemaContext)schema.accept((SchemaVisitor)this);
        assert (ctx != null);
        return new SchemaContext(schema, (Schema.Builder<?>)ObjectSchema.builder().requiresObject(false).addPropertySchema(property, ctx.schema()));
    }

    public SchemaContext visitReadOnlySchema(ReadOnlySchema schema) {
        return (SchemaContext)super.visitReadOnlySchema(schema);
    }

    public SchemaContext visitReferenceSchema(ReferenceSchema schema) {
        Schema referredSchema = schema.getReferredSchema();
        String refValue = schema.getRef();
        if (refValue.startsWith("mem://input")) {
            refValue = refValue.substring("mem://input".length());
        }
        ReferenceSchema.Builder ref = org.everit.json.schema.ReferenceSchema.builder().refValue(refValue);
        this.refMapping.offer((Pair<org.everit.json.schema.ReferenceSchema, Schema>)new Pair((Object)ref.build(), (Object)referredSchema));
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)ref);
    }

    public SchemaContext visitRequiredSchema(RequiredSchema schema) {
        ObjectSchema.Builder builder = ObjectSchema.builder().requiresObject(false);
        for (String p : schema.getRequiredProperties()) {
            builder.addRequiredProperty(p);
        }
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)builder);
    }

    public SchemaContext visitTrueSchema(com.github.erosb.jsonsKema.TrueSchema schema) {
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)TrueSchema.builder());
    }

    public SchemaContext visitTypeSchema(TypeSchema schema) {
        return new SchemaContext((Schema)schema, this.typeToSchema(schema.getType().getValue()));
    }

    public SchemaContext visitUnevaluatedItemsSchema(UnevaluatedItemsSchema schema) {
        SchemaContext ctx = (SchemaContext)super.visitUnevaluatedItemsSchema(schema);
        assert (ctx != null);
        ArraySchema.Builder builder = ArraySchema.builder().requiresArray(false);
        builder.unprocessedProperties(Collections.singletonMap("unevaluatedItems", ctx.schema()));
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)builder);
    }

    public SchemaContext visitUnevaluatedPropertiesSchema(UnevaluatedPropertiesSchema schema) {
        SchemaContext ctx = (SchemaContext)super.visitUnevaluatedPropertiesSchema(schema);
        assert (ctx != null);
        ObjectSchema.Builder builder = ObjectSchema.builder().requiresObject(false);
        builder.unprocessedProperties(Collections.singletonMap("unevaluatedProperties", ctx.schema()));
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)builder);
    }

    public SchemaContext visitUniqueItemsSchema(UniqueItemsSchema schema) {
        return new SchemaContext((Schema)schema, (Schema.Builder<?>)ArraySchema.builder().requiresArray(false).uniqueItems(schema.getUnique()));
    }

    public SchemaContext visitWriteOnlySchema(WriteOnlySchema schema) {
        return (SchemaContext)super.visitWriteOnlySchema(schema);
    }

    private Schema.Builder<?> typeToSchema(String type) {
        switch (type) {
            case "string": {
                return StringSchema.builder();
            }
            case "integer": {
                return NumberSchema.builder().requiresInteger(true);
            }
            case "number": {
                return NumberSchema.builder();
            }
            case "boolean": {
                return BooleanSchema.builder();
            }
            case "null": {
                return NullSchema.builder();
            }
            case "array": {
                return ArraySchema.builder();
            }
            case "object": {
                return ObjectSchema.builder();
            }
        }
        throw new IllegalArgumentException();
    }

    public class SchemaContext
    implements AutoCloseable {
        private final Schema source;
        private final Schema.Builder<?> target;

        public SchemaContext(Schema source, Schema.Builder<?> target) {
            if (target == null) {
                throw new NullPointerException();
            }
            this.source = source;
            this.target = target;
            SchemaTranslator.this.schemaMapping.put(source, target);
        }

        public Schema source() {
            return this.source;
        }

        public Schema.Builder<?> schemaBuilder() {
            return this.target;
        }

        public org.everit.json.schema.Schema schema() {
            return this.target.build();
        }

        public SchemaContext join(Schema parent, SchemaContext ctx) {
            return new SchemaContext(parent, this.join(parent, ctx.schema()));
        }

        public Schema.Builder<?> join(Schema parent, org.everit.json.schema.Schema current) {
            org.everit.json.schema.Schema schema = this.schema();
            if (schema instanceof ArraySchema && current instanceof ArraySchema) {
                return SchemaUtils.merge(SchemaUtils.toBuilder((ArraySchema)schema), (ArraySchema)current);
            }
            if (schema instanceof NumberSchema && current instanceof NumberSchema) {
                return SchemaUtils.merge(SchemaUtils.toBuilder((NumberSchema)schema), (NumberSchema)current);
            }
            if (schema instanceof ObjectSchema && current instanceof ObjectSchema) {
                return SchemaUtils.merge(SchemaUtils.toBuilder((ObjectSchema)schema), (ObjectSchema)current);
            }
            if (schema instanceof StringSchema && current instanceof StringSchema) {
                return SchemaUtils.merge(SchemaUtils.toBuilder((StringSchema)schema), (StringSchema)current);
            }
            if (SchemaUtils.isSyntheticAny(schema) && SchemaUtils.containsType((CombinedSchema)schema, current)) {
                return CombinedSchema.anyOf(this.accumulate(new ArrayList<org.everit.json.schema.Schema>(((CombinedSchema)schema).getSubschemas()), current)).isSynthetic(true);
            }
            if (SchemaUtils.isSyntheticAny(current) && SchemaUtils.containsType((CombinedSchema)current, schema)) {
                return CombinedSchema.anyOf(this.accumulate(new ArrayList<org.everit.json.schema.Schema>(((CombinedSchema)current).getSubschemas()), schema)).isSynthetic(true);
            }
            if (parent instanceof AllOfSchema && schema instanceof CombinedSchema) {
                return CombinedSchema.allOf(this.concat(((CombinedSchema)schema).getSubschemas(), this.flatten(current)));
            }
            if (parent instanceof AnyOfSchema && schema instanceof CombinedSchema) {
                return CombinedSchema.anyOf(this.concat(((CombinedSchema)schema).getSubschemas(), this.flatten(current)));
            }
            if (parent instanceof OneOfSchema && schema instanceof CombinedSchema) {
                return CombinedSchema.oneOf(this.concat(((CombinedSchema)schema).getSubschemas(), this.flatten(current)));
            }
            return CombinedSchema.allOf(this.accumulate(this.concat(this.flatten(schema), this.flatten(current)))).isSynthetic(true);
        }

        private List<org.everit.json.schema.Schema> accumulate(List<org.everit.json.schema.Schema> schemas) {
            List<org.everit.json.schema.Schema> result = new ArrayList<org.everit.json.schema.Schema>();
            for (org.everit.json.schema.Schema schema : schemas) {
                result = this.accumulate(result, schema);
            }
            return result;
        }

        private List<org.everit.json.schema.Schema> accumulate(List<org.everit.json.schema.Schema> product, org.everit.json.schema.Schema current) {
            for (int i = 0; i < product.size(); ++i) {
                org.everit.json.schema.Schema schema = product.get(i);
                if (schema.getClass() != current.getClass()) continue;
                if (schema instanceof ArraySchema) {
                    product.set(i, (org.everit.json.schema.Schema)SchemaUtils.merge(SchemaUtils.toBuilder((ArraySchema)schema), (ArraySchema)current).build());
                    return product;
                }
                if (schema instanceof NumberSchema) {
                    product.set(i, (org.everit.json.schema.Schema)SchemaUtils.merge(SchemaUtils.toBuilder((NumberSchema)schema), (NumberSchema)current).build());
                    return product;
                }
                if (schema instanceof ObjectSchema) {
                    product.set(i, (org.everit.json.schema.Schema)SchemaUtils.merge(SchemaUtils.toBuilder((ObjectSchema)schema), (ObjectSchema)current).build());
                    return product;
                }
                if (!(schema instanceof StringSchema)) continue;
                product.set(i, (org.everit.json.schema.Schema)SchemaUtils.merge(SchemaUtils.toBuilder((StringSchema)schema), (StringSchema)current).build());
                return product;
            }
            product.add(current);
            return product;
        }

        private List<org.everit.json.schema.Schema> concat(Collection<org.everit.json.schema.Schema> previous, Collection<org.everit.json.schema.Schema> current) {
            ArrayList<org.everit.json.schema.Schema> schemas = new ArrayList<org.everit.json.schema.Schema>(previous);
            schemas.addAll(current);
            return schemas;
        }

        private List<org.everit.json.schema.Schema> flatten(org.everit.json.schema.Schema schema) {
            if (SchemaUtils.isSyntheticAll(schema)) {
                CombinedSchema combinedSchema = (CombinedSchema)schema;
                return new ArrayList<org.everit.json.schema.Schema>(combinedSchema.getSubschemas());
            }
            return Collections.singletonList(schema);
        }

        @Override
        public void close() {
            while (!SchemaTranslator.this.refMapping.isEmpty()) {
                Pair pair = (Pair)SchemaTranslator.this.refMapping.poll();
                org.everit.json.schema.ReferenceSchema refSchema = (org.everit.json.schema.ReferenceSchema)pair.component1();
                Schema oldReferredSchema = (Schema)pair.component2();
                Schema.Builder referredSchema = (Schema.Builder)SchemaTranslator.this.schemaMapping.get(oldReferredSchema);
                if (referredSchema != null) {
                    refSchema.setReferredSchema(referredSchema.build());
                    continue;
                }
                SchemaContext ctx = (SchemaContext)oldReferredSchema.accept((SchemaVisitor)SchemaTranslator.this);
                assert (ctx != null);
                ctx.close();
                refSchema.setReferredSchema(ctx.schema());
            }
        }
    }

    static class JsonValueVisitor
    implements JsonVisitor<Object> {
        JsonValueVisitor() {
        }

        public Object accumulate(Object previous, Object current) {
            return current != null ? current : previous;
        }

        public Object identity() {
            return null;
        }

        public Object visitArray(IJsonArray<?> arr) {
            return objectMapper.convertValue(arr, JSONArray.class);
        }

        public Object visitBoolean(IJsonBoolean bool) {
            return bool.getValue();
        }

        public Object visitNull(IJsonNull nil) {
            return null;
        }

        public Object visitNumber(IJsonNumber num) {
            return num.getValue();
        }

        public Object visitObject(IJsonObject<?, ?> obj) {
            return objectMapper.convertValue(obj, JSONObject.class);
        }

        public Object visitString(IJsonString str) {
            return str.getValue();
        }
    }
}

