/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.requestlog;

import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLog
extends AbstractLifeCycle
implements RequestLog {
    private static final Logger log = LoggerFactory.getLogger(CustomLog.class);
    private final CustomRequestLog delegateJettyLog;
    private final String[] requestAttributesToLog;

    public CustomLog(RequestLog.Writer writer, String formatString, String[] requestAttributesToLog) {
        for (String attr : requestAttributesToLog) {
            formatString = formatString + " %{" + attr + "}o";
        }
        this.requestAttributesToLog = requestAttributesToLog;
        this.delegateJettyLog = new CustomRequestLog(writer, formatString);
    }

    protected synchronized void doStart() throws Exception {
        if (this.delegateJettyLog != null) {
            this.delegateJettyLog.start();
        }
    }

    protected void doStop() throws Exception {
        if (this.delegateJettyLog != null) {
            this.delegateJettyLog.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Request request, Response response) {
        for (String attr : this.requestAttributesToLog) {
            Object attrVal = request.getAttribute(attr);
            if (attrVal == null) continue;
            request.removeAttribute(attr);
            response.setHeader(attr, attrVal.toString());
        }
        try {
            this.delegateJettyLog.log(request, response);
        }
        catch (Exception e) {
            log.debug("Logging with Jetty's CustomRequestLogFailed with exception {}, stack is \n{}", (Object)e, (Object)e.getStackTrace());
        }
        finally {
            for (String attr : this.requestAttributesToLog) {
                response.getHttpFields().remove(attr);
            }
        }
    }
}

