/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.response;

import io.confluent.kafkarest.config.ConfigModule;
import io.confluent.kafkarest.response.ChunkedOutputFactory;
import io.confluent.kafkarest.response.JsonStream;
import io.confluent.kafkarest.response.StreamingResponse;
import java.time.Duration;
import java.util.Objects;
import javax.inject.Inject;

public final class StreamingResponseFactory {
    private final ChunkedOutputFactory chunkedOutputFactory;
    private final Duration maxDuration;
    private final Duration gracePeriod;

    @Inject
    public StreamingResponseFactory(ChunkedOutputFactory chunkedOutputFactory, @ConfigModule.StreamingMaxConnectionDurationConfig Duration maxDuration, @ConfigModule.StreamingMaxConnectionGracePeriod Duration gracePeriod) {
        this.chunkedOutputFactory = Objects.requireNonNull(chunkedOutputFactory);
        this.maxDuration = maxDuration;
        this.gracePeriod = gracePeriod;
    }

    public <T> StreamingResponse<T> from(JsonStream<T> inputStream) {
        return StreamingResponse.from(inputStream, this.chunkedOutputFactory, this.maxDuration, this.gracePeriod);
    }
}

