/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.ConsumerRecord;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.PositiveOrZero;

public final class JsonConsumerRecord {
    @NotNull
    @Nullable
    private final String topic;
    @Nullable
    private final Object key;
    @Nullable
    private final Object value;
    @PositiveOrZero
    @Nullable
    private final Integer partition;
    @PositiveOrZero
    @Nullable
    private final Long offset;

    @JsonCreator
    private JsonConsumerRecord(@JsonProperty(value="topic") @Nullable String topic, @JsonProperty(value="key") @Nullable Object key, @JsonProperty(value="value") @Nullable Object value, @JsonProperty(value="partition") @Nullable Integer partition, @JsonProperty(value="offset") @Nullable Long offset) {
        this.topic = topic;
        this.key = key;
        this.value = value;
        this.partition = partition;
        this.offset = offset;
    }

    @JsonProperty
    @Nullable
    public String getTopic() {
        return this.topic;
    }

    @JsonProperty
    @Nullable
    public Object getKey() {
        return this.key;
    }

    @JsonProperty
    @Nullable
    public Object getValue() {
        return this.value;
    }

    @JsonProperty
    @Nullable
    public Integer getPartition() {
        return this.partition;
    }

    @JsonProperty
    @Nullable
    public Long getOffset() {
        return this.offset;
    }

    public static JsonConsumerRecord fromConsumerRecord(ConsumerRecord<Object, Object> record) {
        if (record.getPartition() < 0) {
            throw new IllegalArgumentException();
        }
        if (record.getOffset() < 0L) {
            throw new IllegalArgumentException();
        }
        return new JsonConsumerRecord(Objects.requireNonNull(record.getTopic()), record.getKey(), record.getValue(), record.getPartition(), record.getOffset());
    }

    public ConsumerRecord<Object, Object> toConsumerRecord() {
        if (this.topic == null) {
            throw new IllegalStateException();
        }
        if (this.partition == null || this.partition < 0) {
            throw new IllegalStateException();
        }
        if (this.offset == null || this.offset < 0L) {
            throw new IllegalStateException();
        }
        return ConsumerRecord.create(this.topic, this.key, this.value, this.partition, this.offset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonConsumerRecord that = (JsonConsumerRecord)o;
        return Objects.equals(this.topic, that.topic) && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Objects.equals(this.partition, that.partition) && Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.key, this.value, this.partition, this.offset);
    }

    public String toString() {
        return new StringJoiner(", ", JsonConsumerRecord.class.getSimpleName() + "[", "]").add("topic='" + this.topic + "'").add("key=" + this.key).add("value=" + this.value).add("partition=" + this.partition).add("offset=" + this.offset).toString();
    }
}

