/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Optional;
import kafka.server.BrokerTopicMetrics;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.server.log.remote.storage.RemoteStorageMetrics;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dw!B\u001e=\u0011\u0003\te!B\"=\u0011\u0003!\u0005\"B&\u0002\t\u0003a\u0005bB'\u0002\u0005\u0004%\tA\u0014\u0005\u0007/\u0006\u0001\u000b\u0011B(\t\u000fa\u000b!\u0019!C\u0001\u001d\"1\u0011,\u0001Q\u0001\n=CqAW\u0001C\u0002\u0013\u0005a\n\u0003\u0004\\\u0003\u0001\u0006Ia\u0014\u0005\b9\u0006\u0011\r\u0011\"\u0001O\u0011\u0019i\u0016\u0001)A\u0005\u001f\"9a,\u0001b\u0001\n\u0003q\u0005BB0\u0002A\u0003%q\nC\u0004a\u0003\t\u0007I\u0011\u0001(\t\r\u0005\f\u0001\u0015!\u0003P\u0011\u001d\u0011\u0017A1A\u0005\u00029CaaY\u0001!\u0002\u0013y\u0005b\u00023\u0002\u0005\u0004%\tA\u0014\u0005\u0007K\u0006\u0001\u000b\u0011B(\t\u000f\u0019\f!\u0019!C\u0001\u001d\"1q-\u0001Q\u0001\n=Cq\u0001[\u0001C\u0002\u0013\u0005a\n\u0003\u0004j\u0003\u0001\u0006Ia\u0014\u0005\bU\u0006\u0011\r\u0011\"\u0001O\u0011\u0019Y\u0017\u0001)A\u0005\u001f\"9A.\u0001b\u0001\n\u0003q\u0005BB7\u0002A\u0003%q\nC\u0004o\u0003\t\u0007I\u0011\u0001(\t\r=\f\u0001\u0015!\u0003P\u0011\u001d\u0001\u0018A1A\u0005\u00029Ca!]\u0001!\u0002\u0013y\u0005b\u0002:\u0002\u0005\u0004%\tA\u0014\u0005\u0007g\u0006\u0001\u000b\u0011B(\t\u000fQ\f!\u0019!C\u0001\u001d\"1Q/\u0001Q\u0001\n=CqA^\u0001C\u0002\u0013\u0005a\n\u0003\u0004x\u0003\u0001\u0006Ia\u0014\u0005\bq\u0006\u0011\r\u0011\"\u0001O\u0011\u0019I\u0018\u0001)A\u0005\u001f\"9!0AI\u0001\n\u0003Yh!B\"=\u0001\u0005}\u0001\"CA\u0017Q\t\u0005\t\u0015!\u0003~\u0011\u0019Y\u0005\u0006\"\u0001\u00020!I\u0011Q\u0007\u0015C\u0002\u0013%\u0011q\u0007\u0005\t\u00033B\u0003\u0015!\u0003\u0002:!I\u00111\f\u0015C\u0002\u0013%\u0011Q\f\u0005\t\u0003KB\u0003\u0015!\u0003\u0002`!I\u0011q\r\u0015C\u0002\u0013\u0005\u0011\u0011\u000e\u0005\t\u0003WB\u0003\u0015!\u0003\u0002T!9\u0011Q\u000e\u0015\u0005\u0002\u0005=\u0004bBA;Q\u0011\u0005\u0011q\u000f\u0005\b\u0003\u0013CC\u0011BAF\u0011\u001d\ty\t\u000bC\u0001\u0003#Cq!!&)\t\u0003\t9\nC\u0004\u0002\u001c\"\"\t!!(\t\u000f\u0005\u0005\u0006\u0006\"\u0001\u0002$\"9\u0011q\u0015\u0015\u0005\u0002\u0005%\u0006bBAWQ\u0011\u0005\u0011q\u0016\u0005\b\u0003\u0007DC\u0011AAc\u0003A\u0011%o\\6feR{\u0007/[2Ti\u0006$8O\u0003\u0002>}\u000511/\u001a:wKJT\u0011aP\u0001\u0006W\u000647.Y\u0002\u0001!\t\u0011\u0015!D\u0001=\u0005A\u0011%o\\6feR{\u0007/[2Ti\u0006$8o\u0005\u0002\u0002\u000bB\u0011a)S\u0007\u0002\u000f*\t\u0001*A\u0003tG\u0006d\u0017-\u0003\u0002K\u000f\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A!\u0002!5+7o]1hKNLe\u000eU3s'\u0016\u001cW#A(\u0011\u0005A+V\"A)\u000b\u0005I\u001b\u0016\u0001\u00027b]\u001eT\u0011\u0001V\u0001\u0005U\u00064\u0018-\u0003\u0002W#\n11\u000b\u001e:j]\u001e\f\u0011#T3tg\u0006<Wm]%o!\u0016\u00148+Z2!\u00035\u0011\u0015\u0010^3t\u0013:\u0004VM]*fG\u0006q!)\u001f;fg&s\u0007+\u001a:TK\u000e\u0004\u0013A\u0004\"zi\u0016\u001cx*\u001e;QKJ\u001cVmY\u0001\u0010\u0005f$Xm](viB+'oU3dA\u0005\u0019\")\u001f;fgJ+'.Z2uK\u0012\u0004VM]*fG\u0006!\")\u001f;fgJ+'.Z2uK\u0012\u0004VM]*fG\u0002\n\u0001DU3qY&\u001c\u0017\r^5p]\nKH/Z:J]B+'oU3d\u0003e\u0011V\r\u001d7jG\u0006$\u0018n\u001c8CsR,7/\u00138QKJ\u001cVm\u0019\u0011\u00023I+\u0007\u000f\\5dCRLwN\u001c\"zi\u0016\u001cx*\u001e;QKJ\u001cVmY\u0001\u001b%\u0016\u0004H.[2bi&|gNQ=uKN|U\u000f\u001e)feN+7\rI\u0001\u001c\r\u0006LG.\u001a3Qe>$WoY3SKF,Xm\u001d;t!\u0016\u00148+Z2\u00029\u0019\u000b\u0017\u000e\\3e!J|G-^2f%\u0016\fX/Z:ugB+'oU3dA\u0005Ib)Y5mK\u00124U\r^2i%\u0016\fX/Z:ugB+'oU3d\u0003i1\u0015-\u001b7fI\u001a+Go\u00195SKF,Xm\u001d;t!\u0016\u00148+Z2!\u0003i!v\u000e^1m!J|G-^2f%\u0016\fX/Z:ugB+'oU3d\u0003m!v\u000e^1m!J|G-^2f%\u0016\fX/Z:ugB+'oU3dA\u0005ABk\u001c;bY\u001a+Go\u00195SKF,Xm\u001d;t!\u0016\u00148+Z2\u00023Q{G/\u00197GKR\u001c\u0007NU3rk\u0016\u001cHo\u001d)feN+7\rI\u0001\u001e\r\u0016$8\r['fgN\fw-Z\"p]Z,'o]5p]N\u0004VM]*fG\u0006qb)\u001a;dQ6+7o]1hK\u000e{gN^3sg&|gn\u001d)feN+7\rI\u0001 !J|G-^2f\u001b\u0016\u001c8/Y4f\u0007>tg/\u001a:tS>t7\u000fU3s'\u0016\u001c\u0017\u0001\t)s_\u0012,8-Z'fgN\fw-Z\"p]Z,'o]5p]N\u0004VM]*fG\u0002\n\u0011DU3bgNLwM\\7f]R\u0014\u0015\u0010^3t\u0013:\u0004VM]*fG\u0006Q\"+Z1tg&<g.\\3oi\nKH/Z:J]B+'oU3dA\u0005Q\"+Z1tg&<g.\\3oi\nKH/Z:PkR\u0004VM]*fG\u0006Y\"+Z1tg&<g.\\3oi\nKH/Z:PkR\u0004VM]*fG\u0002\n\u0001ET8LKf\u001cu.\u001c9bGR,G\rV8qS\u000e\u0014VmY8sIN\u0004VM]*fG\u0006\tcj\\&fs\u000e{W\u000e]1di\u0016$Gk\u001c9jGJ+7m\u001c:egB+'oU3dA\u0005y\u0012J\u001c<bY&$W*Y4jG:+XNY3s%\u0016\u001cwN\u001d3t!\u0016\u00148+Z2\u0002A%sg/\u00197jI6\u000bw-[2Ok6\u0014WM\u001d*fG>\u0014Hm\u001d)feN+7\rI\u0001\u001f\u0013:4\u0018\r\\5e\u001b\u0016\u001c8/Y4f\u0007J\u001c'+Z2pe\u0012\u001c\b+\u001a:TK\u000e\fq$\u00138wC2LG-T3tg\u0006<Wm\u0011:d%\u0016\u001cwN\u001d3t!\u0016\u00148+Z2!\u0003\u0011JeN^1mS\u0012|eMZ:fi>\u00138+Z9vK:\u001cWMU3d_J$7\u000fU3s'\u0016\u001c\u0017!J%om\u0006d\u0017\u000eZ(gMN,Go\u0014:TKF,XM\\2f%\u0016\u001cwN\u001d3t!\u0016\u00148+Z2!\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\tAPK\u0002~\u0003\u001b\u0001RA`A\u0002\u0003\u000fi\u0011a \u0006\u0004\u0003\u0003\u0019\u0016\u0001B;uS2L1!!\u0002\u0000\u0005!y\u0005\u000f^5p]\u0006d\u0007c\u0001\"\u0002\n%\u0019\u00111\u0002\u001f\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0016\u0003\u0003\u001f\u0001B!!\u0005\u0002\u001c5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011D$\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001e\u0005M!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dKN!\u0001&RA\u0011!\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u0014}\u0005)Q\u000f^5mg&!\u00111FA\u0013\u0005\u001daunZ4j]\u001e\f\u0011bY8oM&<w\n\u001d;\u0015\t\u0005E\u00121\u0007\t\u0003\u0005\"B\u0001\"!\f+!\u0003\u0005\r!`\u0001\rm\u0006dW/\u001a$bGR|'/_\u000b\u0003\u0003s\u0001rARA\u001e\u0003\u007f\t\u0019&C\u0002\u0002>\u001d\u0013\u0011BR;oGRLwN\\\u0019\u0011\t\u0005\u0005\u0013q\n\b\u0005\u0003\u0007\nY\u0005E\u0002\u0002F\u001dk!!a\u0012\u000b\u0007\u0005%\u0003)\u0001\u0004=e>|GOP\u0005\u0004\u0003\u001b:\u0015A\u0002)sK\u0012,g-C\u0002W\u0003#R1!!\u0014H!\r\u0011\u0015QK\u0005\u0004\u0003/b$A\u0005\"s_.,'\u000fV8qS\u000elU\r\u001e:jGN\fQB^1mk\u00164\u0015m\u0019;pef\u0004\u0013!B:uCR\u001cXCAA0!!\t\u0019#!\u0019\u0002@\u0005M\u0013\u0002BA2\u0003K\u0011A\u0001U8pY\u000611\u000f^1ug\u0002\na\"\u00197m)>\u0004\u0018nY:Ti\u0006$8/\u0006\u0002\u0002T\u0005y\u0011\r\u001c7U_BL7m]*uCR\u001c\b%\u0001\u0006u_BL7m\u0015;biN$B!a\u0015\u0002r!9\u00111O\u0019A\u0002\u0005}\u0012!\u0002;pa&\u001c\u0017\u0001G;qI\u0006$XMU3qY&\u001c\u0017\r^5p]\nKH/Z:J]R!\u0011\u0011PA@!\r1\u00151P\u0005\u0004\u0003{:%\u0001B+oSRDq!!!3\u0001\u0004\t\u0019)A\u0003wC2,X\rE\u0002G\u0003\u000bK1!a\"H\u0005\u0011auN\\4\u00023U\u0004H-\u0019;f%\u0016\u0004H.[2bi&|gNQ=uKN|U\u000f\u001e\u000b\u0005\u0003s\ni\tC\u0004\u0002\u0002N\u0002\r!a!\u00023U\u0004H-\u0019;f%\u0016\f7o]5h]6,g\u000e\u001e\"zi\u0016\u001c\u0018J\u001c\u000b\u0005\u0003s\n\u0019\nC\u0004\u0002\u0002R\u0002\r!a!\u00025U\u0004H-\u0019;f%\u0016\f7o]5h]6,g\u000e\u001e\"zi\u0016\u001cx*\u001e;\u0015\t\u0005e\u0014\u0011\u0014\u0005\b\u0003\u0003+\u0004\u0019AAB\u0003Y\u0011X-\\8wK>cG\rT3bI\u0016\u0014X*\u001a;sS\u000e\u001cH\u0003BA=\u0003?Cq!a\u001d7\u0001\u0004\ty$\u0001\rsK6|g/Z(mI\u001a{G\u000e\\8xKJlU\r\u001e:jGN$B!!\u001f\u0002&\"9\u00111O\u001cA\u0002\u0005}\u0012!\u0004:f[>4X-T3ue&\u001c7\u000f\u0006\u0003\u0002z\u0005-\u0006bBA:q\u0001\u0007\u0011qH\u0001\u000fkB$\u0017\r^3CsR,7oT;u))\tI(!-\u00024\u0006u\u0016\u0011\u0019\u0005\b\u0003gJ\u0004\u0019AA \u0011\u001d\t),\u000fa\u0001\u0003o\u000b!\"[:G_2dwn^3s!\r1\u0015\u0011X\u0005\u0004\u0003w;%a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u007fK\u0004\u0019AA\\\u00039I7OU3bgNLwM\\7f]RDq!!!:\u0001\u0004\t\u0019)A\u0003dY>\u001cX\r\u0006\u0002\u0002z\u0001")
public class BrokerTopicStats
implements Logging {
    private final Optional<KafkaConfig> configOpt;
    private final Function1<String, BrokerTopicMetrics> valueFactory;
    private final Pool<String, BrokerTopicMetrics> stats;
    private final BrokerTopicMetrics allTopicsStats;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Optional<KafkaConfig> $lessinit$greater$default$1() {
        return Optional.empty();
    }

    public static String InvalidOffsetOrSequenceRecordsPerSec() {
        return BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec();
    }

    public static String InvalidMessageCrcRecordsPerSec() {
        return BrokerTopicStats$.MODULE$.InvalidMessageCrcRecordsPerSec();
    }

    public static String InvalidMagicNumberRecordsPerSec() {
        return BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec();
    }

    public static String NoKeyCompactedTopicRecordsPerSec() {
        return BrokerTopicStats$.MODULE$.NoKeyCompactedTopicRecordsPerSec();
    }

    public static String ReassignmentBytesOutPerSec() {
        return BrokerTopicStats$.MODULE$.ReassignmentBytesOutPerSec();
    }

    public static String ReassignmentBytesInPerSec() {
        return BrokerTopicStats$.MODULE$.ReassignmentBytesInPerSec();
    }

    public static String ProduceMessageConversionsPerSec() {
        return BrokerTopicStats$.MODULE$.ProduceMessageConversionsPerSec();
    }

    public static String FetchMessageConversionsPerSec() {
        return BrokerTopicStats$.MODULE$.FetchMessageConversionsPerSec();
    }

    public static String TotalFetchRequestsPerSec() {
        return BrokerTopicStats$.MODULE$.TotalFetchRequestsPerSec();
    }

    public static String TotalProduceRequestsPerSec() {
        return BrokerTopicStats$.MODULE$.TotalProduceRequestsPerSec();
    }

    public static String FailedFetchRequestsPerSec() {
        return BrokerTopicStats$.MODULE$.FailedFetchRequestsPerSec();
    }

    public static String FailedProduceRequestsPerSec() {
        return BrokerTopicStats$.MODULE$.FailedProduceRequestsPerSec();
    }

    public static String ReplicationBytesOutPerSec() {
        return BrokerTopicStats$.MODULE$.ReplicationBytesOutPerSec();
    }

    public static String ReplicationBytesInPerSec() {
        return BrokerTopicStats$.MODULE$.ReplicationBytesInPerSec();
    }

    public static String BytesRejectedPerSec() {
        return BrokerTopicStats$.MODULE$.BytesRejectedPerSec();
    }

    public static String BytesOutPerSec() {
        return BrokerTopicStats$.MODULE$.BytesOutPerSec();
    }

    public static String BytesInPerSec() {
        return BrokerTopicStats$.MODULE$.BytesInPerSec();
    }

    public static String MessagesInPerSec() {
        return BrokerTopicStats$.MODULE$.MessagesInPerSec();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Function1<String, BrokerTopicMetrics> valueFactory() {
        return this.valueFactory;
    }

    private Pool<String, BrokerTopicMetrics> stats() {
        return this.stats;
    }

    public BrokerTopicMetrics allTopicsStats() {
        return this.allTopicsStats;
    }

    public BrokerTopicMetrics topicStats(String topic) {
        return this.stats().getAndMaybePut(topic);
    }

    public void updateReplicationBytesIn(long value) {
        this.allTopicsStats().replicationBytesInRate().foreach((Function1 & Serializable)metric -> {
            metric.mark(value);
            return BoxedUnit.UNIT;
        });
    }

    private void updateReplicationBytesOut(long value) {
        this.allTopicsStats().replicationBytesOutRate().foreach((Function1 & Serializable)metric -> {
            metric.mark(value);
            return BoxedUnit.UNIT;
        });
    }

    public void updateReassignmentBytesIn(long value) {
        this.allTopicsStats().reassignmentBytesInPerSec().foreach((Function1 & Serializable)metric -> {
            metric.mark(value);
            return BoxedUnit.UNIT;
        });
    }

    public void updateReassignmentBytesOut(long value) {
        this.allTopicsStats().reassignmentBytesOutPerSec().foreach((Function1 & Serializable)metric -> {
            metric.mark(value);
            return BoxedUnit.UNIT;
        });
    }

    public void removeOldLeaderMetrics(String topic) {
        BrokerTopicMetrics topicMetrics = this.topicStats(topic);
        if (topicMetrics != null) {
            topicMetrics.closeMetric(BrokerTopicStats$.MODULE$.MessagesInPerSec());
            topicMetrics.closeMetric(BrokerTopicStats$.MODULE$.BytesInPerSec());
            topicMetrics.closeMetric(BrokerTopicStats$.MODULE$.BytesRejectedPerSec());
            topicMetrics.closeMetric(BrokerTopicStats$.MODULE$.FailedProduceRequestsPerSec());
            topicMetrics.closeMetric(BrokerTopicStats$.MODULE$.TotalProduceRequestsPerSec());
            topicMetrics.closeMetric(BrokerTopicStats$.MODULE$.ProduceMessageConversionsPerSec());
            topicMetrics.closeMetric(BrokerTopicStats$.MODULE$.ReplicationBytesOutPerSec());
            topicMetrics.closeMetric(BrokerTopicStats$.MODULE$.ReassignmentBytesOutPerSec());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_COPY_BYTES_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_FETCH_BYTES_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_FETCH_REQUESTS_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_COPY_REQUESTS_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.FAILED_REMOTE_FETCH_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.FAILED_REMOTE_COPY_PER_SEC_METRIC.getName());
            return;
        }
    }

    public void removeOldFollowerMetrics(String topic) {
        BrokerTopicMetrics topicMetrics = this.topicStats(topic);
        if (topicMetrics != null) {
            topicMetrics.closeMetric(BrokerTopicStats$.MODULE$.ReplicationBytesInPerSec());
            topicMetrics.closeMetric(BrokerTopicStats$.MODULE$.ReassignmentBytesInPerSec());
            return;
        }
    }

    public void removeMetrics(String topic) {
        BrokerTopicMetrics metrics = this.stats().remove(topic);
        if (metrics != null) {
            metrics.close();
            return;
        }
    }

    public void updateBytesOut(String topic, boolean isFollower, boolean isReassignment, long value) {
        if (isFollower) {
            if (isReassignment) {
                this.updateReassignmentBytesOut(value);
            }
            this.updateReplicationBytesOut(value);
            return;
        }
        this.topicStats(topic).bytesOutRate().mark(value);
        this.allTopicsStats().bytesOutRate().mark(value);
    }

    public void close() {
        this.allTopicsStats().close();
        this.stats().values().foreach((Function1 & Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable)() -> "Broker and topic stats closed");
    }

    public BrokerTopicStats(Optional<KafkaConfig> configOpt) {
        this.configOpt = configOpt;
        this.valueFactory = (Function1 & Serializable)k -> new BrokerTopicMetrics((Option<String>)new Some(k), $this.configOpt);
        this.stats = new Pool(new Some(this.valueFactory()));
        this.allTopicsStats = new BrokerTopicMetrics((Option<String>)None$.MODULE$, configOpt);
    }
}

