/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.ratelimit;

import io.confluent.kafkarest.exceptions.StatusCodeException;
import javax.ws.rs.core.Response;

public final class RateLimitExceededException
extends StatusCodeException {
    public RateLimitExceededException() {
        super(Response.Status.TOO_MANY_REQUESTS, "Request rate limit exceeded", "The rate limit of requests per second has been exceeded.");
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    public static class ErrorCodes {
        public static final int PRODUCE_MAX_REQUESTS_GLOBAL_LIMIT_EXCEEDED = 429001;
        public static final int PRODUCE_MAX_REQUESTS_PER_TENANT_LIMIT_EXCEEDED = 429002;
        public static final int PRODUCE_MAX_BYTES_GLOBAL_LIMIT_EXCEEDED = 429003;
        public static final int PRODUCE_MAX_BYTES_PER_TENANT_LIMIT_EXCEEDED = 429004;
        public static final int PERMITS_MAX_GLOBAL_LIMIT_EXCEEDED = 429005;
        public static final int PERMITS_MAX_PER_CLUSTER_LIMIT_EXCEEDED = 429006;
        public static final int DOS_FILTER_MAX_REQUEST_LIMIT_EXCEEDED = 429007;
        public static final int DOS_FILTER_MAX_REQUEST_PER_CONNECTION_LIMIT_EXCEEDED = 429008;
    }
}

