/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$ShutdownRequest$;
import kafka.network.RequestChannel$WakeupRequest$;
import kafka.server.ApiRequestHandler;
import kafka.server.KafkaRequestHandler$;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005-w!B\u0013'\u0011\u0003Yc!B\u0017'\u0011\u0003q\u0003\"B\u001b\u0002\t\u00031\u0004bB\u001c\u0002\u0005\u0004%I\u0001\u000f\u0005\u0007\u000f\u0006\u0001\u000b\u0011B\u001d\t\u000f!\u000b!\u0019!C\u0005\u0013\"1!+\u0001Q\u0001\n)CqaU\u0001A\u0002\u0013%A\u000bC\u0004Y\u0003\u0001\u0007I\u0011B-\t\r}\u000b\u0001\u0015)\u0003V\u0011\u0015!\u0017\u0001\"\u0001f\u0011\u0015A\u0017\u0001\"\u0001j\u0011\u0015Q\u0017\u0001\"\u0001l\r\u0015ic\u0005AA\u0006\u0011)\t)#\u0004B\u0001B\u0003%\u0011q\u0005\u0005\u000b\u0003[i!\u0011!Q\u0001\n\u0005\u001d\u0002BCA\u0018\u001b\t\u0015\r\u0011\"\u0001\u00022!Q\u00111J\u0007\u0003\u0002\u0003\u0006I!a\r\t\u0015\u00055SB!b\u0001\n\u0003\ty\u0005\u0003\u0006\u0002f5\u0011\t\u0011)A\u0005\u0003#B!\"a\u001a\u000e\u0005\u000b\u0007I\u0011AA5\u0011%\tY'\u0004B\u0001B\u0003%\u0011\t\u0003\u0006\u0002n5\u0011\t\u0011)A\u0005\u0003_B!\"!\u001e\u000e\u0005\u0003\u0005\u000b\u0011BA<\u0011\u0019)T\u0002\"\u0001\u0002\u0010\"I\u0011\u0011U\u0007C\u0002\u0013%\u00111\u0015\u0005\t\u0003[k\u0001\u0015!\u0003\u0002&\"I\u0011\u0011B\u0007C\u0002\u0013%\u0011q\u0016\u0005\t\u0003ck\u0001\u0015!\u0003\u0002\u0002!A\u00111W\u0007A\u0002\u0013%A\u000bC\u0005\u000266\u0001\r\u0011\"\u0003\u00028\"9\u00111X\u0007!B\u0013)\u0006bBA`\u001b\u0011\u0005\u0011\u0011\u0019\u0005\b\u0003\u0007lA\u0011BAa\u0011\u001d\t)-\u0004C\u0001\u0003\u0003Dq!a2\u000e\t\u0003\t\t\rC\u0004\u0002J6!\t!!1\u0002'-\u000bgm[1SKF,Xm\u001d;IC:$G.\u001a:\u000b\u0005\u001dB\u0013AB:feZ,'OC\u0001*\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001L\u0001\u000e\u0003\u0019\u00121cS1gW\u0006\u0014V-];fgRD\u0015M\u001c3mKJ\u001c\"!A\u0018\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1&\u0001\u000buQJ,\u0017\r\u001a*fcV,7\u000f^\"iC:tW\r\\\u000b\u0002sA\u0019!hP!\u000e\u0003mR!\u0001P\u001f\u0002\t1\fgn\u001a\u0006\u0002}\u0005!!.\u0019<b\u0013\t\u00015HA\u0006UQJ,\u0017\r\u001a'pG\u0006d\u0007C\u0001\"F\u001b\u0005\u0019%B\u0001#)\u0003\u001dqW\r^<pe.L!AR\"\u0003\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY\u0006)B\u000f\u001b:fC\u0012\u0014V-];fgR\u001c\u0005.\u00198oK2\u0004\u0013\u0001\u0006;ie\u0016\fGmQ;se\u0016tGOU3rk\u0016\u001cH/F\u0001K!\rQth\u0013\t\u0003\u0019>s!AQ'\n\u00059\u001b\u0015A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0003!F\u0013qAU3rk\u0016\u001cHO\u0003\u0002O\u0007\u0006)B\u000f\u001b:fC\u0012\u001cUO\u001d:f]R\u0014V-];fgR\u0004\u0013!\u00052za\u0006\u001c8\u000f\u00165sK\u0006$7\t[3dWV\tQ\u000b\u0005\u00021-&\u0011q+\r\u0002\b\u0005>|G.Z1o\u0003U\u0011\u0017\u0010]1tgRC'/Z1e\u0007\",7m[0%KF$\"AW/\u0011\u0005AZ\u0016B\u0001/2\u0005\u0011)f.\u001b;\t\u000fyC\u0011\u0011!a\u0001+\u0006\u0019\u0001\u0010J\u0019\u0002%\tL\b/Y:t)\"\u0014X-\u00193DQ\u0016\u001c7\u000e\t\u0015\u0003\u0013\u0005\u0004\"\u0001\r2\n\u0005\r\f$\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002)M,GOQ=qCN\u001cH\u000b\u001b:fC\u0012\u001c\u0005.Z2l)\tQf\rC\u0003h\u0015\u0001\u0007Q+A\u0006csB\f7o]\"iK\u000e\\\u0017AF2veJ,g\u000e\u001e*fcV,7\u000f^(o)\"\u0014X-\u00193\u0015\u0003-\u000b\u0011c\u001e:ba\u0006\u001b\u0018P\\2DC2d'-Y2l+\ta'\u000f\u0006\u0003nw\u0006\u001d\u0001\u0003\u0002\u0019oajK!a\\\u0019\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA9s\u0019\u0001!Qa\u001d\u0007C\u0002Q\u0014\u0011\u0001V\t\u0003kb\u0004\"\u0001\r<\n\u0005]\f$a\u0002(pi\"Lgn\u001a\t\u0003aeL!A_\u0019\u0003\u0007\u0005s\u0017\u0010C\u0003}\u0019\u0001\u0007Q0A\fbgft7mQ8na2,G/[8o\u0007\u0006dGNY1dWB1\u0001G`A\u0001ajK!a`\u0019\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004c\u0001\u0017\u0002\u0004%\u0019\u0011Q\u0001\u0014\u0003\u0019I+\u0017/^3ti2{7-\u00197\t\u000f\u0005%A\u00021\u0001\u0002\u0002\u0005a!/Z9vKN$Hj\\2bYN9Q\"!\u0004\u0002\u0014\u0005e\u0001c\u0001\u001e\u0002\u0010%\u0019\u0011\u0011C\u001e\u0003\r=\u0013'.Z2u!\rQ\u0014QC\u0005\u0004\u0003/Y$\u0001\u0003*v]:\f'\r\\3\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b)\u0003\u0015)H/\u001b7t\u0013\u0011\t\u0019#!\b\u0003\u000f1{wmZ5oO\u0006\u0011\u0011\u000e\u001a\t\u0004a\u0005%\u0012bAA\u0016c\t\u0019\u0011J\u001c;\u0002\u0011\t\u0014xn[3s\u0013\u0012\f!#Y4he\u0016<\u0017\r^3JI2,W*\u001a;feV\u0011\u00111\u0007\t\u0005\u0003k\t9%\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003\u0011\u0019wN]3\u000b\t\u0005u\u0012qH\u0001\b[\u0016$(/[2t\u0015\u0011\t\t%a\u0011\u0002\re\fW.\\3s\u0015\t\t)%A\u0002d_6LA!!\u0013\u00028\t)Q*\u001a;fe\u0006\u0019\u0012mZ4sK\u001e\fG/Z%eY\u0016lU\r^3sA\u0005\u0019Bo\u001c;bY\"\u000bg\u000e\u001a7feRC'/Z1egV\u0011\u0011\u0011\u000b\t\u0005\u0003'\n\t'\u0004\u0002\u0002V)!\u0011qKA-\u0003\u0019\tGo\\7jG*!\u00111LA/\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003?j\u0014\u0001B;uS2LA!a\u0019\u0002V\ti\u0011\t^8nS\u000eLe\u000e^3hKJ\fA\u0003^8uC2D\u0015M\u001c3mKJ$\u0006N]3bIN\u0004\u0013A\u0004:fcV,7\u000f^\"iC:tW\r\\\u000b\u0002\u0003\u0006y!/Z9vKN$8\t[1o]\u0016d\u0007%\u0001\u0003ba&\u001c\bc\u0001\u0017\u0002r%\u0019\u00111\u000f\u0014\u0003#\u0005\u0003\u0018NU3rk\u0016\u001cH\u000fS1oI2,'/\u0001\u0003uS6,\u0007\u0003BA=\u0003\u0017k!!a\u001f\u000b\t\u0005}\u0011Q\u0010\u0006\u0005\u0003\u007f\n\t)\u0001\u0004d_6lwN\u001c\u0006\u0004S\u0005\r%\u0002BAC\u0003\u000f\u000ba!\u00199bG\",'BAAE\u0003\ry'oZ\u0005\u0005\u0003\u001b\u000bYH\u0001\u0003US6,G\u0003EAI\u0003'\u000b)*a&\u0002\u001a\u0006m\u0015QTAP!\taS\u0002C\u0004\u0002&a\u0001\r!a\n\t\u000f\u00055\u0002\u00041\u0001\u0002(!9\u0011q\u0006\rA\u0002\u0005M\u0002bBA'1\u0001\u0007\u0011\u0011\u000b\u0005\u0007\u0003OB\u0002\u0019A!\t\u000f\u00055\u0004\u00041\u0001\u0002p!9\u0011Q\u000f\rA\u0002\u0005]\u0014\u0001E:ikR$wn\u001e8D_6\u0004H.\u001a;f+\t\t)\u000b\u0005\u0003\u0002(\u0006%VBAA-\u0013\u0011\tY+!\u0017\u0003\u001d\r{WO\u001c;E_^tG*\u0019;dQ\u0006\t2\u000f[;uI><hnQ8na2,G/\u001a\u0011\u0016\u0005\u0005\u0005\u0011!\u0004:fcV,7\u000f\u001e'pG\u0006d\u0007%A\u0004ti>\u0004\b/\u001a3\u0002\u0017M$x\u000e\u001d9fI~#S-\u001d\u000b\u00045\u0006e\u0006b\u00020\u001f\u0003\u0003\u0005\r!V\u0001\tgR|\u0007\u000f]3eA!\u0012q$Y\u0001\u0004eVtG#\u0001.\u0002!\r|W\u000e\u001d7fi\u0016\u001c\u0006.\u001e;e_^t\u0017\u0001B:u_B\f\u0001#\u001b8ji&\fG/Z*ikR$wn\u001e8\u0002\u001b\u0005<\u0018-\u001b;TQV$Hm\\<o\u0001")
public class KafkaRequestHandler
implements Runnable,
Logging {
    private final int id;
    private final int brokerId;
    private final Meter aggregateIdleMeter;
    private final AtomicInteger totalHandlerThreads;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final CountDownLatch shutdownComplete;
    private final RequestLocal requestLocal;
    private volatile boolean stopped;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <T> Function1<T, BoxedUnit> wrapAsyncCallback(Function2<RequestLocal, T, BoxedUnit> asyncCompletionCallback, RequestLocal requestLocal) {
        return KafkaRequestHandler$.MODULE$.wrapAsyncCallback(asyncCompletionCallback, requestLocal);
    }

    public static RequestChannel.Request currentRequestOnThread() {
        return KafkaRequestHandler$.MODULE$.currentRequestOnThread();
    }

    public static void setBypassThreadCheck(boolean bypassCheck) {
        KafkaRequestHandler$.MODULE$.setBypassThreadCheck(bypassCheck);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public AtomicInteger totalHandlerThreads() {
        return this.totalHandlerThreads;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private CountDownLatch shutdownComplete() {
        return this.shutdownComplete;
    }

    private RequestLocal requestLocal() {
        return this.requestLocal;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    @Override
    public void run() {
        KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadRequestChannel().set(this.requestChannel());
        while (!this.stopped()) {
            long startSelectTime = this.time.nanoseconds();
            RequestChannel.BaseRequest req = this.requestChannel().receiveRequest(300L);
            long endTime = this.time.nanoseconds();
            long idleTime = endTime - startSelectTime;
            this.aggregateIdleMeter().mark(idleTime / (long)this.totalHandlerThreads().get());
            if (RequestChannel$ShutdownRequest$.MODULE$.equals(req)) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" received shut down command").toString());
                this.completeShutdown();
                return;
            }
            if (req instanceof RequestChannel.CallbackRequest) {
                RequestChannel.CallbackRequest callbackRequest = (RequestChannel.CallbackRequest)req;
                RequestChannel.Request originalRequest = callbackRequest.originalRequest();
                try {
                    try {
                        if (originalRequest.callbackRequestDequeueTimeNanos().isDefined()) {
                            long prevCallbacksTimeNanos = BoxesRunTime.unboxToLong((Object)originalRequest.callbackRequestCompleteTimeNanos().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) - BoxesRunTime.unboxToLong((Object)originalRequest.callbackRequestDequeueTimeNanos().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
                            originalRequest.callbackRequestCompleteTimeNanos_$eq((Option<Object>)None$.MODULE$);
                            originalRequest.callbackRequestDequeueTimeNanos_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(this.time.nanoseconds() - prevCallbacksTimeNanos))));
                        } else {
                            originalRequest.callbackRequestDequeueTimeNanos_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.time.nanoseconds())));
                        }
                        KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().set(originalRequest);
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)callbackRequest.fun().apply((Object)this.requestLocal());
                        continue;
                    }
                    catch (FatalExitError e) {
                        this.completeShutdown();
                        throw Exit$.MODULE$.exit(e.statusCode(), (Option<String>)None$.MODULE$);
                    }
                    catch (Throwable e) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> "Exception when handling request", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                        continue;
                    }
                }
                finally {
                    this.apis.tryCompleteActions();
                    if (originalRequest.callbackRequestCompleteTimeNanos().isEmpty()) {
                        originalRequest.callbackRequestCompleteTimeNanos_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.time.nanoseconds())));
                    }
                    KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().remove();
                    continue;
                }
            }
            if (req instanceof RequestChannel.Request) {
                RequestChannel.Request request = (RequestChannel.Request)req;
                try {
                    try {
                        request.requestDequeueTimeNanos_$eq(endTime);
                        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" handling request ").append(request).toString());
                        KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().set(request);
                        this.apis.handle(request, this.requestLocal());
                        continue;
                    }
                    catch (FatalExitError e) {
                        this.completeShutdown();
                        throw Exit$.MODULE$.exit(e.statusCode(), (Option<String>)None$.MODULE$);
                    }
                    catch (Throwable e) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> "Exception when handling request", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                        continue;
                    }
                }
                finally {
                    KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().remove();
                    request.releaseBuffer();
                    continue;
                }
            }
            if (RequestChannel$WakeupRequest$.MODULE$.equals(req)) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> "Received a wakeup request outside of typical usage.");
                continue;
            }
            if (req == null) continue;
            throw new MatchError((Object)req);
        }
        this.completeShutdown();
    }

    private void completeShutdown() {
        this.requestLocal().close();
        KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadRequestChannel().remove();
        this.shutdownComplete().countDown();
    }

    public void stop() {
        this.stopped_$eq(true);
    }

    public void initiateShutdown() {
        this.requestChannel().sendShutdownRequest();
    }

    public void awaitShutdown() {
        this.shutdownComplete().await();
    }

    public KafkaRequestHandler(int id, int brokerId, Meter aggregateIdleMeter, AtomicInteger totalHandlerThreads, RequestChannel requestChannel, ApiRequestHandler apis, Time time) {
        this.id = id;
        this.brokerId = brokerId;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.totalHandlerThreads = totalHandlerThreads;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        this.logIdent_$eq(new StringBuilder(37).append("[Kafka Request Handler ").append(id).append(" on Broker ").append(brokerId).append("], ").toString());
        this.shutdownComplete = new CountDownLatch(1);
        this.requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        this.stopped = false;
    }
}

