/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.EnumSet;
import kafka.api.LeaderAndIsr$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.server.ConfigType$;
import kafka.utils.Logging;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zk.TopicPartitionZNode$;
import kafka.zk.TopicPartitionsZNode$;
import kafka.zk.TopicZNode;
import kafka.zk.TopicZNode$;
import kafka.zk.ZkMigrationClient$;
import kafka.zk.ZkVersion$;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.SetDataRequest;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.migration.MigrationClientAuthException;
import org.apache.kafka.metadata.migration.MigrationClientException;
import org.apache.kafka.metadata.migration.TopicMigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Iterable;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Uh\u0001B\n\u0015\u0001mA\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\u0006w\u0001!\t\u0001\u0010\u0005\u0006\u0001\u0002!\t%\u0011\u0005\u0006U\u0002!\te\u001b\u0005\b\u0003?\u0001A\u0011BA\u0011\u0011\u001d\t\t\u0005\u0001C\u0005\u0003\u0007Bq!!\u0011\u0001\t\u0013\tI\u0006C\u0004\u0002`\u0001!\t%!\u0019\t\u000f\u0005-\u0004\u0001\"\u0011\u0002n!9\u00111\u000f\u0001\u0005B\u0005U\u0004bBA@\u0001\u0011\u0005\u0013\u0011\u0011\u0005\b\u0003\u000f\u0003A\u0011IAE\u0011\u001d\t9\n\u0001C\u0005\u00033Cq!!*\u0001\t\u0013\t9\u000bC\u0004\u0002L\u0002!I!!4\t\u000f\u0005U\u0007\u0001\"\u0003\u0002X\"9\u0011Q\u001d\u0001\u0005B\u0005\u001d\bbBAv\u0001\u0011\u0005\u0013Q\u001e\u0002\u00175.$v\u000e]5d\u001b&<'/\u0019;j_:\u001cE.[3oi*\u0011QCF\u0001\n[&<'/\u0019;j_:T!a\u0006\r\u0002\u0005i\\'\"A\r\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\b\u00131!\ti\"%D\u0001\u001f\u0015\ty\u0002%\u0001\u0003mC:<'\"A\u0011\u0002\t)\fg/Y\u0005\u0003Gy\u0011aa\u00142kK\u000e$\bCA\u0013/\u001b\u00051#BA\u000b(\u0015\tA\u0013&\u0001\u0005nKR\fG-\u0019;b\u0015\tI\"F\u0003\u0002,Y\u00051\u0011\r]1dQ\u0016T\u0011!L\u0001\u0004_J<\u0017BA\u0018'\u0005Q!v\u000e]5d\u001b&<'/\u0019;j_:\u001cE.[3oiB\u0011\u0011\u0007N\u0007\u0002e)\u00111\u0007G\u0001\u0006kRLGn]\u0005\u0003kI\u0012q\u0001T8hO&tw-\u0001\u0005{W\u000ec\u0017.\u001a8u!\tA\u0014(D\u0001\u0017\u0013\tQdCA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005uz\u0004C\u0001 \u0001\u001b\u0005!\u0002\"\u0002\u001c\u0003\u0001\u00049\u0014!D5uKJ\fG/\u001a+pa&\u001c7\u000fF\u0002C\u0011\u0012\u0004\"a\u0011$\u000e\u0003\u0011S\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\u0012\u0013A!\u00168ji\")\u0011j\u0001a\u0001\u0015\u0006I\u0011N\u001c;fe\u0016\u001cHo\u001d\t\u0004\u0017:\u0003V\"\u0001'\u000b\u00055\u0003\u0013\u0001B;uS2L!a\u0014'\u0003\u000f\u0015sW/\\*fiB\u0011\u0011+\u0019\b\u0003%~s!a\u00150\u000f\u0005QkfBA+]\u001d\t16L\u0004\u0002X56\t\u0001L\u0003\u0002Z5\u00051AH]8pizJ\u0011!L\u0005\u0003W1J!!\u0007\u0016\n\u0005!J\u0013BA\u000b(\u0013\t\u0001g%\u0001\u000bU_BL7-T5he\u0006$\u0018n\u001c8DY&,g\u000e^\u0005\u0003E\u000e\u0014A\u0003V8qS\u000e4\u0016n]5u_JLe\u000e^3sKN$(B\u00011'\u0011\u0015)7\u00011\u0001g\u0003\u001d1\u0018n]5u_J\u0004\"a\u001a5\u000f\u0005\u0015z\u0016BA5d\u00051!v\u000e]5d-&\u001c\u0018\u000e^8s\u0003-\u0019'/Z1uKR{\u0007/[2\u0015\u000f1|\u00170a\u0001\u0002\u001cA\u0011Q%\\\u0005\u0003]\u001a\u0012!DW6NS\u001e\u0014\u0018\r^5p]2+\u0017\rZ3sg\"L\u0007o\u0015;bi\u0016DQ\u0001\u001d\u0003A\u0002E\f\u0011\u0002^8qS\u000et\u0015-\\3\u0011\u0005I4hBA:u!\t9F)\u0003\u0002v\t\u00061\u0001K]3eK\u001aL!a\u001e=\u0003\rM#(/\u001b8h\u0015\t)H\tC\u0003{\t\u0001\u000710A\u0004u_BL7-\u00133\u0011\u0005q|X\"A?\u000b\u0005yL\u0013AB2p[6|g.C\u0002\u0002\u0002u\u0014A!V;jI\"9\u0011Q\u0001\u0003A\u0002\u0005\u001d\u0011A\u00039beRLG/[8ogB91*!\u0003\u0002\u000e\u0005M\u0011bAA\u0006\u0019\n\u0019Q*\u00199\u0011\u0007u\ty!C\u0002\u0002\u0012y\u0011q!\u00138uK\u001e,'\u000f\u0005\u0003\u0002\u0016\u0005]Q\"A\u0014\n\u0007\u0005eqEA\u000bQCJ$\u0018\u000e^5p]J+w-[:ue\u0006$\u0018n\u001c8\t\r\u0005uA\u00011\u0001m\u0003\u0015\u0019H/\u0019;f\u0003\t\u001a'/Z1uKR{\u0007/[2QCJ$\u0018\u000e^5p]jsu\u000eZ3t%\u0016\fX/Z:ugRA\u00111EA\u001e\u0003{\ty\u0004\u0005\u0004\u0002&\u0005-\u0012qF\u0007\u0003\u0003OQ1!!\u000bE\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003[\t9CA\u0002TKF\u0004B!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003kA\u0012!\u0003>p_.,W\r]3s\u0013\u0011\tI$a\r\u0003\u001b\r\u0013X-\u0019;f%\u0016\fX/Z:u\u0011\u0015\u0001X\u00011\u0001r\u0011\u001d\t)!\u0002a\u0001\u0003\u000fAa!!\b\u0006\u0001\u0004a\u0017!\u0005:fGV\u00148/\u001b<f\u0007\"LG\u000e\u001a:f]R)!)!\u0012\u0002J!1\u0011q\t\u0004A\u0002E\fA\u0001]1uQ\"9\u00111\n\u0004A\u0002\u00055\u0013aA1dGB)\u0011qJA+c6\u0011\u0011\u0011\u000b\u0006\u0005\u0003'\n9#A\u0004nkR\f'\r\\3\n\t\u0005]\u0013\u0011\u000b\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0006\u0003\u0002\\\u0005u\u0003#BA\u0013\u0003W\t\bBBA$\u000f\u0001\u0007\u0011/A\u0006va\u0012\fG/\u001a+pa&\u001cG#\u00037\u0002d\u0005\u0015\u0014qMA5\u0011\u0015\u0001\b\u00021\u0001r\u0011\u0015Q\b\u00021\u0001|\u0011\u001d\t)\u0001\u0003a\u0001\u0003\u000fAa!!\b\t\u0001\u0004a\u0017a\u00033fY\u0016$X\rV8qS\u000e$R\u0001\\A8\u0003cBQ\u0001]\u0005A\u0002EDa!!\b\n\u0001\u0004a\u0017!F2sK\u0006$X\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0006Y\u0006]\u0014Q\u0010\u0005\b\u0003sR\u0001\u0019AA>\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\bCB&\u0002\nE\f9\u0001\u0003\u0004\u0002\u001e)\u0001\r\u0001\\\u0001\u0016kB$\u0017\r^3U_BL7\rU1si&$\u0018n\u001c8t)\u0015a\u00171QAC\u0011\u001d\tIh\u0003a\u0001\u0003wBa!!\b\f\u0001\u0004a\u0017!\u00063fY\u0016$X\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0006Y\u0006-\u0015Q\u0013\u0005\b\u0003sb\u0001\u0019AAG!\u0019Y\u0015\u0011B9\u0002\u0010B)1*!%\u0002\u000e%\u0019\u00111\u0013'\u0003\u0007M+G\u000f\u0003\u0004\u0002\u001e1\u0001\r\u0001\\\u0001\u0015GJ,\u0017\r^3U_BL7\rU1si&$\u0018n\u001c8\u0015\t\u0005=\u00121\u0014\u0005\b\u0003;k\u0001\u0019AAP\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u00042\u0001`AQ\u0013\r\t\u0019+ \u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003e\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016\u0004\u0016\r\u001e5B]\u0012$\u0015\r^1\u0015\u0011\u0005%\u00161XA_\u0003\u0003\u0004baQAVc\u0006=\u0016bAAW\t\n1A+\u001e9mKJ\u0002RaQAY\u0003kK1!a-E\u0005\u0015\t%O]1z!\r\u0019\u0015qW\u0005\u0004\u0003s#%\u0001\u0002\"zi\u0016Dq!!(\u000f\u0001\u0004\ty\nC\u0004\u0002@:\u0001\r!a\u0005\u0002+A\f'\u000f^5uS>t'+Z4jgR\u0014\u0018\r^5p]\"9\u00111\u0019\bA\u0002\u0005\u0015\u0017aD2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\u0011\u0007\r\u000b9-C\u0002\u0002J\u0012\u00131!\u00138u\u0003e\u0019'/Z1uKR{\u0007/[2QCJ$\u0018\u000e^5p]N#\u0018\r^3\u0015\u0011\u0005=\u0012qZAi\u0003'Dq!!(\u0010\u0001\u0004\ty\nC\u0004\u0002@>\u0001\r!a\u0005\t\u000f\u0005\rw\u00021\u0001\u0002F\u0006IR\u000f\u001d3bi\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f)!\tI.a8\u0002b\u0006\r\b\u0003BA\u0019\u00037LA!!8\u00024\tq1+\u001a;ECR\f'+Z9vKN$\bbBAO!\u0001\u0007\u0011q\u0014\u0005\b\u0003\u007f\u0003\u0002\u0019AA\n\u0011\u001d\t\u0019\r\u0005a\u0001\u0003\u000b\f\u0011D]3bIB+g\u000eZ5oOR{\u0007/[2EK2,G/[8ogR\u0011\u0011\u0011\u001e\t\u0005\u0017\u0006E\u0015/\u0001\u000edY\u0016\f'\u000fU3oI&tw\rV8qS\u000e$U\r\\3uS>t7\u000fF\u0003m\u0003_\f\u0019\u0010C\u0004\u0002rJ\u0001\r!!;\u0002+A,g\u000eZ5oOR{\u0007/[2EK2,G/[8og\"1\u0011Q\u0004\nA\u00021\u0004")
public class ZkTopicMigrationClient
implements TopicMigrationClient,
Logging {
    private final KafkaZkClient zkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void iterateTopics(EnumSet<TopicMigrationClient.TopicVisitorInterest> interests, TopicMigrationClient.TopicVisitor visitor) {
        try {
            ZkTopicMigrationClient.$anonfun$iterateTopics$1(this, interests, visitor);
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState createTopic(String topicName, Uuid topicId, java.util.Map<Integer, PartitionRegistration> partitions, ZkMigrationLeadershipState state) {
        try {
            return ZkTopicMigrationClient.$anonfun$createTopic$1(this, partitions, topicName, topicId, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    private Seq<CreateRequest> createTopicPartitionZNodesRequests(String topicName, java.util.Map<Integer, PartitionRegistration> partitions, ZkMigrationLeadershipState state) {
        String path = TopicPartitionsZNode$.MODULE$.path(topicName);
        CreateRequest createPartitionsZNode = new CreateRequest(path, null, this.zkClient.defaultAcls(path), CreateMode.PERSISTENT, (Option<Object>)None$.MODULE$);
        scala.collection.immutable.Seq createPartitionZNodeReqs = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.MapHasAsScala(partitions).asScala().toSeq().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Integer partitionId = (Integer)x0$1._1();
                PartitionRegistration partition = (PartitionRegistration)x0$1._2();
                TopicPartition topicPartition = new TopicPartition(topicName, Predef$.MODULE$.Integer2int(partitionId));
                return new .colon.colon((Object)this.createTopicPartition(topicPartition), (List)new .colon.colon((Object)this.createTopicPartitionState(topicPartition, partition, state.kraftControllerEpoch()), (List)Nil$.MODULE$));
            }
            throw new MatchError(null);
        });
        return (Seq)new .colon.colon((Object)createPartitionsZNode, (List)Nil$.MODULE$).$plus$plus((IterableOnce)createPartitionZNodeReqs);
    }

    private void recursiveChildren(String path, ArrayBuffer<String> acc) {
        ((GetChildrenResponse)this.zkClient.retryRequestUntilConnected(new GetChildrenRequest(path, false, (Option<Object>)None$.MODULE$), this.zkClient.retryRequestUntilConnected$default$2())).children().foreach((Function1 & Serializable)child -> {
            this.recursiveChildren(new StringBuilder(1).append(path).append("/").append((String)child).toString(), acc);
            return (ArrayBuffer)acc.append((Object)new StringBuilder(1).append(path).append("/").append((String)child).toString());
        });
    }

    private Seq<String> recursiveChildren(String path) {
        ArrayBuffer buffer = new ArrayBuffer();
        this.recursiveChildren(path, (ArrayBuffer<String>)buffer);
        return buffer.toSeq();
    }

    public ZkMigrationLeadershipState updateTopic(String topicName, Uuid topicId, java.util.Map<Integer, PartitionRegistration> partitions, ZkMigrationLeadershipState state) {
        try {
            return ZkTopicMigrationClient.$anonfun$updateTopic$1(this, partitions, topicName, topicId, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState deleteTopic(String topicName, ZkMigrationLeadershipState state) {
        try {
            return ZkTopicMigrationClient.$anonfun$deleteTopic$1(this, topicName, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState createTopicPartitions(java.util.Map<String, java.util.Map<Integer, PartitionRegistration>> topicPartitions, ZkMigrationLeadershipState state) {
        try {
            return ZkTopicMigrationClient.$anonfun$createTopicPartitions$1(this, topicPartitions, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState updateTopicPartitions(java.util.Map<String, java.util.Map<Integer, PartitionRegistration>> topicPartitions, ZkMigrationLeadershipState state) {
        try {
            return ZkTopicMigrationClient.$anonfun$updateTopicPartitions$1(this, topicPartitions, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ZkMigrationLeadershipState deleteTopicPartitions(java.util.Map<String, java.util.Set<Integer>> topicPartitions, ZkMigrationLeadershipState state) {
        void var6_6;
        Iterable requests = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(topicPartitions).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                java.util.Set partitionIds = (java.util.Set)x0$1._2();
                return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(partitionIds).asScala().map((Function1 & Serializable)partitionId -> {
                    TopicPartition topicPartition = new TopicPartition(topicName, Predef$.MODULE$.Integer2int(partitionId));
                    String path = TopicPartitionZNode$.MODULE$.path(topicPartition);
                    return new DeleteRequest(path, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$);
                });
            }
            throw new MatchError(null);
        });
        if (requests.isEmpty()) {
            return state;
        }
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = this.zkClient.retryMigrationRequestsUntilConnected(requests.toSeq(), state);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var6_6.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (resultCodes.forall((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$deleteTopicPartitions$4(x0$2)))) {
            void var5_5;
            return state.withMigrationZkVersion((int)var5_5);
        }
        throw new MigrationClientException(new StringBuilder(64).append("Failed to delete partition states: ").append(topicPartitions).append(". ZK transaction had results ").append(resultCodes).toString());
    }

    private CreateRequest createTopicPartition(TopicPartition topicPartition) {
        try {
            return ZkTopicMigrationClient.$anonfun$createTopicPartition$1(this, topicPartition);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    private Tuple2<String, byte[]> partitionStatePathAndData(TopicPartition topicPartition, PartitionRegistration partitionRegistration, int controllerEpoch) {
        String path = TopicPartitionStateZNode$.MODULE$.path(topicPartition);
        byte[] data = TopicPartitionStateZNode$.MODULE$.encode(new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(partitionRegistration.leader, partitionRegistration.leaderEpoch, (List<Object>)Predef$.MODULE$.wrapIntArray(partitionRegistration.isr).toList(), partitionRegistration.leaderRecoveryState, partitionRegistration.partitionEpoch), controllerEpoch));
        return new Tuple2((Object)path, (Object)data);
    }

    /*
     * WARNING - void declaration
     */
    private CreateRequest createTopicPartitionState(TopicPartition topicPartition, PartitionRegistration partitionRegistration, int controllerEpoch) {
        void var6_6;
        void var5_5;
        Tuple2<String, byte[]> tuple2 = this.partitionStatePathAndData(topicPartition, partitionRegistration, controllerEpoch);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String path = (String)tuple2._1();
        byte[] data = (byte[])tuple2._2();
        return new CreateRequest((String)var5_5, (byte[])var6_6, this.zkClient.defaultAcls((String)var5_5), CreateMode.PERSISTENT, (Option<Object>)new Some((Object)topicPartition));
    }

    /*
     * WARNING - void declaration
     */
    private SetDataRequest updateTopicPartitionState(TopicPartition topicPartition, PartitionRegistration partitionRegistration, int controllerEpoch) {
        void var6_6;
        void var5_5;
        Tuple2<String, byte[]> tuple2 = this.partitionStatePathAndData(topicPartition, partitionRegistration, controllerEpoch);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String path = (String)tuple2._1();
        byte[] data = (byte[])tuple2._2();
        return new SetDataRequest((String)var5_5, (byte[])var6_6, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)new Some((Object)topicPartition));
    }

    public java.util.Set<String> readPendingTopicDeletions() {
        return CollectionConverters$.MODULE$.SetHasAsJava((Set)this.zkClient.getTopicDeletions().toSet()).asJava();
    }

    /*
     * WARNING - void declaration
     */
    public ZkMigrationLeadershipState clearPendingTopicDeletions(java.util.Set<String> pendingTopicDeletions, ZkMigrationLeadershipState state) {
        void var6_6;
        scala.collection.immutable.Seq deleteRequests = ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(pendingTopicDeletions).asScala().map((Function1 & Serializable)topicName -> new DeleteRequest(DeleteTopicsTopicZNode$.MODULE$.path((String)topicName), ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$))).toSeq();
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = this.zkClient.retryMigrationRequestsUntilConnected(deleteRequests.toSeq(), state);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var6_6.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (resultCodes.forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$clearPendingTopicDeletions$3(x0$1)))) {
            void var5_5;
            return state.withMigrationZkVersion((int)var5_5);
        }
        throw new MigrationClientException(new StringBuilder(71).append("Failed to delete pending topic deletions: ").append(pendingTopicDeletions).append(". ZK transaction had results ").append(resultCodes).toString());
    }

    public static final /* synthetic */ void $anonfun$iterateTopics$3(ZkTopicMigrationClient $this, String deletion) {
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("Not migrating pending deleted topic: {}", (Object)deletion);
        }
    }

    public static final /* synthetic */ void $anonfun$iterateTopics$8(ZkTopicMigrationClient $this, Option topicIdOpt$1, Map leaderIsrAndControllerEpochs$1, TopicMigrationClient.TopicVisitor visitor$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$3._1();
            ReplicaAssignment replicaAssignment = (ReplicaAssignment)x0$3._2();
            java.util.List replicaList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicaAssignment.replicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava();
            PartitionRecord record = new PartitionRecord().setTopicId((Uuid)topicIdOpt$1.get()).setPartitionId(topicPartition.partition()).setReplicas(replicaList).setAddingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicaAssignment.addingReplicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setRemovingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicaAssignment.removingReplicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava());
            Option option = leaderIsrAndControllerEpochs$1.get((Object)topicPartition);
            if (option instanceof Some) {
                LeaderIsrAndControllerEpoch leaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value();
                record.setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)leaderIsrAndEpoch.leaderAndIsr().isr().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setLeader(leaderIsrAndEpoch.leaderAndIsr().leader()).setLeaderEpoch(leaderIsrAndEpoch.leaderAndIsr().leaderEpoch()).setPartitionEpoch(leaderIsrAndEpoch.leaderAndIsr().partitionEpoch()).setLeaderRecoveryState(leaderIsrAndEpoch.leaderAndIsr().leaderRecoveryState().value());
            } else if (None$.MODULE$.equals(option)) {
                $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(101).append("Could not find partition state in ZK for ").append(topicPartition).append(". Initializing this partition ").append("with ISR={").append(replicaList).append("} and leaderEpoch=0.").toString());
                record.setIsr(replicaList).setLeader(Predef$.MODULE$.Integer2int((Integer)replicaList.get(0))).setLeaderEpoch(0).setPartitionEpoch(0).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value());
            } else {
                throw new MatchError((Object)option);
            }
            String logAndRethrow_msg = new StringBuilder(49).append("Error in partition consumer. TopicPartition was ").append(topicPartition).append(".").toString();
            try {
                visitor$1.visitPartition(new TopicIdPartition((Uuid)topicIdOpt$1.get(), topicPartition), new PartitionRegistration(record));
                return;
            }
            catch (Throwable logAndRethrow_e) {
                $this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                throw logAndRethrow_e;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$iterateTopics$4(ZkTopicMigrationClient $this, TopicMigrationClient.TopicVisitor visitor$1, EnumSet interests$1, TopicZNode.TopicIdReplicaAssignment x0$1) {
        if (x0$1 != null) {
            String topic = x0$1.topic();
            Option<Uuid> topicIdOpt = x0$1.topicId();
            Map<TopicPartition, ReplicaAssignment> partitionAssignments = x0$1.assignment();
            java.util.Map topicAssignment = CollectionConverters$.MODULE$.MapHasAsJava((Map)partitionAssignments.map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    TopicPartition partition = (TopicPartition)x0$2._1();
                    ReplicaAssignment assignment = (ReplicaAssignment)x0$2._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition.partition())), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)assignment.replicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava());
                }
                throw new MatchError(null);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
            String logAndRethrow_msg = new StringBuilder(36).append("Error in topic consumer. Topic was ").append(topic).append(".").toString();
            try {
                visitor$1.visitTopic(topic, (Uuid)topicIdOpt.get(), topicAssignment);
            }
            catch (Throwable logAndRethrow_e) {
                $this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                throw logAndRethrow_e;
            }
            Object var10_8 = null;
            if (interests$1.contains(TopicMigrationClient.TopicVisitorInterest.PARTITIONS)) {
                scala.collection.immutable.Seq partitions = partitionAssignments.keys().toSeq();
                Map<TopicPartition, LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochs = $this.zkClient.getTopicPartitionStates((Seq<TopicPartition>)partitions);
                partitionAssignments.foreach((Function1 & Serializable)x0$3 -> {
                    ZkTopicMigrationClient.$anonfun$iterateTopics$8($this, topicIdOpt, leaderIsrAndControllerEpochs, visitor$1, x0$3);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$iterateTopics$1(ZkTopicMigrationClient $this, EnumSet interests$1, TopicMigrationClient.TopicVisitor visitor$1) {
        if (!interests$1.contains(TopicMigrationClient.TopicVisitorInterest.TOPICS)) {
            throw new IllegalArgumentException("Must specify at least TOPICS in topic visitor interests.");
        }
        scala.collection.immutable.Set<String> allTopics = $this.zkClient.getAllTopicsInCluster($this.zkClient.getAllTopicsInCluster$default$1());
        scala.collection.mutable.Set topicDeletions = CollectionConverters$.MODULE$.SetHasAsScala($this.readPendingTopicDeletions()).asScala();
        scala.collection.immutable.Set topicsToMigrated = (scala.collection.immutable.Set)allTopics.$minus$minus((IterableOnce)topicDeletions);
        if (topicDeletions.nonEmpty()) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(163).append("Found ").append(topicDeletions.size()).append(" pending topic deletions. These will be not migrated ").append("to KRaft. After the migration, the brokers will reconcile their logs with these pending topic deletions.").toString());
        }
        topicDeletions.foreach((Function1 & Serializable)deletion -> {
            ZkTopicMigrationClient.$anonfun$iterateTopics$3($this, deletion);
            return BoxedUnit.UNIT;
        });
        $this.zkClient.getReplicaAssignmentAndTopicIdForTopics((scala.collection.immutable.Set<String>)topicsToMigrated).foreach((Function1 & Serializable)x0$1 -> {
            ZkTopicMigrationClient.$anonfun$iterateTopics$4($this, visitor$1, interests$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$createTopic$4(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((KeeperException.Code)x0$2._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$createTopic$1(ZkTopicMigrationClient $this, java.util.Map partitions$1, String topicName$1, Uuid topicId$1, ZkMigrationLeadershipState state$1) {
        void var12_12;
        Seq<CreateRequest> createPartitionZNodeReqs;
        scala.collection.mutable.Map assignments = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(partitions$1).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                void apply_removingReplicas;
                void apply_addingReplicas;
                Integer partitionId = (Integer)x0$1._1();
                PartitionRegistration partition = (PartitionRegistration)x0$1._2();
                ArraySeq.ofInt ofInt2 = Predef$.MODULE$.wrapIntArray(partition.removingReplicas);
                ArraySeq.ofInt ofInt3 = Predef$.MODULE$.wrapIntArray(partition.addingReplicas);
                ArraySeq.ofInt apply_replicas = Predef$.MODULE$.wrapIntArray(partition.replicas);
                Object var4_6 = null;
                ofInt3 = null;
                ofInt2 = null;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topicName$1, Predef$.MODULE$.Integer2int(partitionId))), (Object)new ReplicaAssignment((Seq<Object>)apply_replicas, (Seq<Object>)apply_addingReplicas, (Seq<Object>)apply_removingReplicas));
            }
            throw new MatchError(null);
        });
        String path = TopicZNode$.MODULE$.path(topicName$1);
        CreateRequest createTopicZNode = new CreateRequest(path, TopicZNode$.MODULE$.encode((Option<Uuid>)new Some((Object)topicId$1), (Map<TopicPartition, ReplicaAssignment>)assignments), $this.zkClient.defaultAcls(path), CreateMode.PERSISTENT, (Option<Object>)None$.MODULE$);
        Seq requests = (Seq)new .colon.colon((Object)createTopicZNode, (List)Nil$.MODULE$).$plus$plus(createPartitionZNodeReqs = $this.createTopicPartitionZNodesRequests(topicName$1, partitions$1, state$1));
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests, state$1);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var12_12.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (((Enum)resultCodes.apply((Object)TopicZNode$.MODULE$.path(topicName$1))).equals(KeeperException.Code.NODEEXISTS)) {
            return state$1;
        }
        if (resultCodes.forall((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$createTopic$4(x0$2)))) {
            void var11_11;
            return state$1.withMigrationZkVersion((int)var11_11);
        }
        throw new MigrationClientException(new StringBuilder(61).append("Failed to create or update topic ").append(topicName$1).append(". ZK operations had results ").append(resultCodes).toString());
    }

    public static final /* synthetic */ boolean $anonfun$updateTopic$4(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((KeeperException.Code)x0$2._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$updateTopic$1(ZkTopicMigrationClient $this, java.util.Map partitions$2, String topicName$3, Uuid topicId$2, ZkMigrationLeadershipState state$3) {
        void var9_9;
        scala.collection.mutable.Map assignments = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(partitions$2).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                void apply_removingReplicas;
                void apply_addingReplicas;
                Integer partitionId = (Integer)x0$1._1();
                PartitionRegistration partition = (PartitionRegistration)x0$1._2();
                ArraySeq.ofInt ofInt2 = Predef$.MODULE$.wrapIntArray(partition.removingReplicas);
                ArraySeq.ofInt ofInt3 = Predef$.MODULE$.wrapIntArray(partition.addingReplicas);
                ArraySeq.ofInt apply_replicas = Predef$.MODULE$.wrapIntArray(partition.replicas);
                Object var4_6 = null;
                ofInt3 = null;
                ofInt2 = null;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topicName$3, Predef$.MODULE$.Integer2int(partitionId))), (Object)new ReplicaAssignment((Seq<Object>)apply_replicas, (Seq<Object>)apply_addingReplicas, (Seq<Object>)apply_removingReplicas));
            }
            throw new MatchError(null);
        });
        SetDataRequest request = new SetDataRequest(TopicZNode$.MODULE$.path(topicName$3), TopicZNode$.MODULE$.encode((Option<Uuid>)new Some((Object)topicId$2), (Map<TopicPartition, ReplicaAssignment>)assignments), ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$);
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(new .colon.colon((Object)request, (List)Nil$.MODULE$), state$3);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var9_9.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (resultCodes.forall((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$updateTopic$4(x0$2)))) {
            void var8_8;
            return state$3.withMigrationZkVersion((int)var8_8);
        }
        throw new MigrationClientException(new StringBuilder(62).append("Failed to update topic metadata: ").append(topicName$3).append(". ZK transaction had results ").append(resultCodes).toString());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$deleteTopic$1(ZkTopicMigrationClient $this, String topicName$4, ZkMigrationLeadershipState state$4) {
        void var7_7;
        String topicPath = TopicZNode$.MODULE$.path(topicName$4);
        Seq deleteRequests = (Seq)((IterableOps)$this.recursiveChildren(topicPath).map((Function1 & Serializable)childPath -> new DeleteRequest((String)childPath, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$))).$plus$plus((IterableOnce)new .colon.colon((Object)new DeleteRequest(ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.Topic(), topicName$4), ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$), (List)new .colon.colon((Object)new DeleteRequest(TopicZNode$.MODULE$.path(topicName$4), ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$), (List)Nil$.MODULE$)));
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(deleteRequests, state$4);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var7_7.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (((DeleteResponse)var7_7.last()).resultCode().equals((Object)KeeperException.Code.OK)) {
            void var6_6;
            return state$4.withMigrationZkVersion((int)var6_6);
        }
        throw new MigrationClientException(new StringBuilder(51).append("Failed to delete topic ").append(topicName$4).append(". ZK operations had results ").append(resultCodes).toString());
    }

    public static final /* synthetic */ boolean $anonfun$createTopicPartitions$4(Tuple2 x0$2) {
        if (x0$2 != null) {
            KeeperException.Code code = (KeeperException.Code)x0$2._2();
            return code.equals((Object)KeeperException.Code.OK) || code.equals((Object)KeeperException.Code.NODEEXISTS);
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$createTopicPartitions$1(ZkTopicMigrationClient $this, java.util.Map topicPartitions$1, ZkMigrationLeadershipState state$5) {
        void var6_6;
        scala.collection.immutable.Seq requests = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.MapHasAsScala(topicPartitions$1).asScala().toSeq().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                java.util.Map partitions = (java.util.Map)x0$1._2();
                return $this.createTopicPartitionZNodesRequests(topicName, partitions, state$5);
            }
            throw new MatchError(null);
        });
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests, state$5);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var6_6.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (resultCodes.forall((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$createTopicPartitions$4(x0$2)))) {
            void var5_5;
            return state$5.withMigrationZkVersion((int)var5_5);
        }
        throw new MigrationClientException(new StringBuilder(64).append("Failed to create partition states: ").append(topicPartitions$1).append(". ZK transaction had results ").append(resultCodes).toString());
    }

    public static final /* synthetic */ boolean $anonfun$updateTopicPartitions$5(Tuple2 x0$3) {
        if (x0$3 != null) {
            return ((KeeperException.Code)x0$3._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$updateTopicPartitions$1(ZkTopicMigrationClient $this, java.util.Map topicPartitions$2, ZkMigrationLeadershipState state$6) {
        void var6_6;
        Iterable requests = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(topicPartitions$2).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                java.util.Map partitionRegistrations = (java.util.Map)x0$1._2();
                return (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(partitionRegistrations).asScala().flatMap((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        Integer partitionId = (Integer)x0$2._1();
                        PartitionRegistration partitionRegistration = (PartitionRegistration)x0$2._2();
                        TopicPartition topicPartition = new TopicPartition(topicName, Predef$.MODULE$.Integer2int(partitionId));
                        return new .colon.colon((Object)$this.updateTopicPartitionState(topicPartition, partitionRegistration, state$6.kraftControllerEpoch()), (List)Nil$.MODULE$);
                    }
                    throw new MatchError(null);
                });
            }
            throw new MatchError(null);
        });
        if (requests.isEmpty()) {
            return state$6;
        }
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests.toSeq(), state$6);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var6_6.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (resultCodes.forall((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$updateTopicPartitions$5(x0$3)))) {
            void var5_5;
            return state$6.withMigrationZkVersion((int)var5_5);
        }
        throw new MigrationClientException(new StringBuilder(64).append("Failed to update partition states: ").append(topicPartitions$2).append(". ZK transaction had results ").append(resultCodes).toString());
    }

    public static final /* synthetic */ boolean $anonfun$deleteTopicPartitions$4(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((KeeperException.Code)x0$2._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ CreateRequest $anonfun$createTopicPartition$1(ZkTopicMigrationClient $this, TopicPartition topicPartition$2) {
        String path = TopicPartitionZNode$.MODULE$.path(topicPartition$2);
        return new CreateRequest(path, null, $this.zkClient.defaultAcls(path), CreateMode.PERSISTENT, (Option<Object>)new Some((Object)topicPartition$2));
    }

    public static final /* synthetic */ boolean $anonfun$clearPendingTopicDeletions$3(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((KeeperException.Code)x0$1._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    public ZkTopicMigrationClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
    }
}

