/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.controllers.ConsumerGroupManager;
import io.confluent.kafkarest.controllers.ConsumerManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.entities.Consumer;
import io.confluent.kafkarest.entities.ConsumerGroup;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;

final class ConsumerManagerImpl
implements ConsumerManager {
    private final ConsumerGroupManager consumerGroupManager;

    @Inject
    ConsumerManagerImpl(ConsumerGroupManager consumerGroupManager) {
        this.consumerGroupManager = consumerGroupManager;
    }

    @Override
    public CompletableFuture<List<Consumer>> listConsumers(String clusterId, String consumerGroupId) {
        return ((CompletableFuture)this.consumerGroupManager.getConsumerGroup(clusterId, consumerGroupId).thenApply(consumerGroup -> (ConsumerGroup)Entities.checkEntityExists(consumerGroup, "Consumer Group %s does not exist.", consumerGroupId))).thenApply(ConsumerGroup::getConsumers);
    }

    @Override
    public CompletableFuture<Optional<Consumer>> getConsumer(String clusterId, String consumerGroupId, String consumerId) {
        return this.listConsumers(clusterId, consumerGroupId).thenApply(consumers -> Entities.findEntityByKey(consumers, Consumer::getConsumerId, consumerId));
    }
}

