/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.log.UnifiedLog;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.runtime.CoordinatorLoader;
import org.apache.kafka.coordinator.group.runtime.CoordinatorPlayback;
import org.apache.kafka.coordinator.group.runtime.Deserializer;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001B\u0007\u000f\u0001UA\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003U\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u001dy\u0006A1A\u0005\n\u0001Daa\u001b\u0001!\u0002\u0013\t\u0007b\u00027\u0001\u0005\u0004%I!\u001c\u0005\u0007i\u0002\u0001\u000b\u0011\u00028\t\u000bU\u0004A\u0011\t<\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:!9\u00111\u000b\u0001\u0005B\u0005U#!F\"p_J$\u0017N\\1u_Jdu.\u00193fe&k\u0007\u000f\u001c\u0006\u0003\u001fA\tQa\u001a:pkBT!!\u0005\n\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002'\u0005)1.\u00194lC\u000e\u0001QC\u0001\f/'\u0011\u0001qc\b\u001e\u0011\u0005aiR\"A\r\u000b\u0005iY\u0012\u0001\u00027b]\u001eT\u0011\u0001H\u0001\u0005U\u00064\u0018-\u0003\u0002\u001f3\t1qJ\u00196fGR\u00042\u0001\t\u0016-\u001b\u0005\t#B\u0001\u0012$\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0004\u0013\u000b\u0005E)#BA\n'\u0015\t9\u0003&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002S\u0005\u0019qN]4\n\u0005-\n#!E\"p_J$\u0017N\\1u_Jdu.\u00193feB\u0011QF\f\u0007\u0001\t\u0015y\u0003A1\u00011\u0005\u0005!\u0016CA\u00198!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\r\u001d\n\u0005e\u001a$aA!osB\u00111HP\u0007\u0002y)\u0011QHE\u0001\u0006kRLGn]\u0005\u0003\u007fq\u0012q\u0001T8hO&tw-\u0001\u0003uS6,\u0007C\u0001\"G\u001b\u0005\u0019%BA\u001fE\u0015\t)U%\u0001\u0004d_6lwN\\\u0005\u0003\u000f\u000e\u0013A\u0001V5nK\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bC\u0001&N\u001b\u0005Y%B\u0001'\u0013\u0003\u0019\u0019XM\u001d<fe&\u0011aj\u0013\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u00031!Wm]3sS\u0006d\u0017N_3s!\r\u0001\u0013\u000bL\u0005\u0003%\u0006\u0012A\u0002R3tKJL\u0017\r\\5{KJ\fa\u0002\\8bI\n+hMZ3s'&TX\r\u0005\u00023+&\u0011ak\r\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\bF\u0003Z7rkf\fE\u0002[\u00011j\u0011A\u0004\u0005\u0006\u0001\u0016\u0001\r!\u0011\u0005\u0006\u0011\u0016\u0001\r!\u0013\u0005\u0006\u001f\u0016\u0001\r\u0001\u0015\u0005\u0006'\u0016\u0001\r\u0001V\u0001\nSN\u0014VO\u001c8j]\u001e,\u0012!\u0019\t\u0003E&l\u0011a\u0019\u0006\u0003I\u0016\fa!\u0019;p[&\u001c'B\u00014h\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003Qn\tA!\u001e;jY&\u0011!n\u0019\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u0015%\u001c(+\u001e8oS:<\u0007%A\u0005tG\",G-\u001e7feV\ta\u000e\u0005\u0002pe6\t\u0001O\u0003\u0002ic*\u0011A*J\u0005\u0003gB\u0014abS1gW\u0006\u001c6\r[3ek2,'/\u0001\u0006tG\",G-\u001e7fe\u0002\nA\u0001\\8bIR)q/a\t\u00020A\u0019\u00010_>\u000e\u0003\u0015L!A_3\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\rE\u0002}\u0003;q1!`A\r\u001d\rq\u0018q\u0003\b\u0004\u007f\u0006Ua\u0002BA\u0001\u0003'qA!a\u0001\u0002\u00129!\u0011QAA\b\u001d\u0011\t9!!\u0004\u000e\u0005\u0005%!bAA\u0006)\u00051AH]8pizJ\u0011!K\u0005\u0003O!J!a\u0005\u0014\n\u0005E)\u0013BA\b%\u0013\t\u00113%C\u0002\u0002\u001c\u0005\n\u0011cQ8pe\u0012Lg.\u0019;pe2{\u0017\rZ3s\u0013\u0011\ty\"!\t\u0003\u00171{\u0017\rZ*v[6\f'/\u001f\u0006\u0004\u00037\t\u0003bBA\u0013\u0015\u0001\u0007\u0011qE\u0001\u0003iB\u0004B!!\u000b\u0002,5\tA)C\u0002\u0002.\u0011\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0012\u0015\u0001\u0007\u0011\u0011\u0007\t\u0005A\u0005MB&C\u0002\u00026\u0005\u00121cQ8pe\u0012Lg.\u0019;peBc\u0017-\u001f2bG.\fa\u0001Z8M_\u0006$GCCA\u001e\u0003\u0003\n\u0019%!\u0012\u0002JA\u0019!'!\u0010\n\u0007\u0005}2G\u0001\u0003V]&$\bbBA\u0013\u0017\u0001\u0007\u0011q\u0005\u0005\u0007#-\u0001\r!!\r\t\r\u0005\u001d3\u00021\u0001x\u0003\u00191W\u000f^;sK\"9\u00111J\u0006A\u0002\u00055\u0013aC:uCJ$H+[7f\u001bN\u00042AMA(\u0013\r\t\tf\r\u0002\u0005\u0019>tw-A\u0003dY>\u001cX\r\u0006\u0002\u0002<\u0001")
public class CoordinatorLoaderImpl<T>
implements CoordinatorLoader<T>,
Logging {
    private final Time time;
    private final ReplicaManager replicaManager;
    private final Deserializer<T> deserializer;
    private final int loadBufferSize;
    private final AtomicBoolean isRunning;
    private final KafkaScheduler scheduler;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean isRunning() {
        return this.isRunning;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    public CompletableFuture<CoordinatorLoader.LoadSummary> load(TopicPartition tp, CoordinatorPlayback<T> coordinator) {
        CompletableFuture<CoordinatorLoader.LoadSummary> future = new CompletableFuture<CoordinatorLoader.LoadSummary>();
        long startTimeMs = this.time.milliseconds();
        if (this.scheduler().scheduleOnce(new StringBuilder(22).append("Load coordinator from ").append(tp).toString(), () -> this.doLoad(tp, coordinator, future, startTimeMs)).isCancelled()) {
            future.completeExceptionally(new RuntimeException("Coordinator loader is closed."));
        }
        return future;
    }

    private void doLoad(TopicPartition tp, CoordinatorPlayback<T> coordinator, CompletableFuture<CoordinatorLoader.LoadSummary> future, long startTimeMs) {
        block16: {
            long schedulerQueueTimeMs = this.time.milliseconds() - startTimeMs;
            try {
                Option<UnifiedLog> option = this.replicaManager.getLog(tp);
                if (None$.MODULE$.equals(option)) {
                    future.completeExceptionally(new NotLeaderOrFollowerException(new StringBuilder(60).append("Could not load records from ").append(tp).append(" because the log does not exist.").toString()));
                    break block16;
                }
                if (option instanceof Some) {
                    UnifiedLog log = (UnifiedLog)((Some)option).value();
                    ByteBuffer buffer = ByteBuffer.allocate(0);
                    LongRef currentOffset = LongRef.create((long)log.logStartOffset());
                    boolean readAtLeastOneRecord = true;
                    LongRef previousHighWatermark = LongRef.create((long)-1L);
                    IntRef numRecords = IntRef.create((int)0);
                    int numBytes = 0;
                    while (currentOffset.elem < this.logEndOffset$1(tp) && readAtLeastOneRecord && this.isRunning().get()) {
                        MemoryRecords memoryRecords;
                        FetchDataInfo fetchDataInfo = log.read(currentOffset.elem, this.loadBufferSize, FetchIsolation.LOG_END, true);
                        readAtLeastOneRecord = fetchDataInfo.records.sizeInBytes() > 0;
                        Records records = fetchDataInfo.records;
                        if (records instanceof MemoryRecords) {
                            memoryRecords = (MemoryRecords)records;
                        } else if (records instanceof FileRecords) {
                            FileRecords fileRecords = (FileRecords)records;
                            int sizeInBytes = fileRecords.sizeInBytes();
                            int bytesNeeded = Math.max(this.loadBufferSize, sizeInBytes);
                            if (buffer.capacity() < bytesNeeded) {
                                if (this.loadBufferSize < bytesNeeded) {
                                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("Loaded metadata from ").append(tp).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").append("configured buffer size (").append($this.loadBufferSize).append(" bytes).").toString());
                                }
                                buffer = ByteBuffer.allocate(bytesNeeded);
                            } else {
                                buffer.clear();
                            }
                            fileRecords.readInto(buffer, 0);
                            memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                        } else {
                            throw new MatchError((Object)records);
                        }
                        MemoryRecords memoryRecords2 = memoryRecords;
                        memoryRecords2.batches().forEach(batch -> {
                            if (batch.isControlBatch()) {
                                CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                                    CoordinatorLoaderImpl.$anonfun$doLoad$4(coordinator, batch, record);
                                    return BoxedUnit.UNIT;
                                });
                            } else {
                                CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                                    CoordinatorLoaderImpl.$anonfun$doLoad$5(this, numRecords, coordinator, batch, tp, record);
                                    return BoxedUnit.UNIT;
                                });
                            }
                            currentOffset$1.elem = batch.nextOffset();
                            long currentHighWatermark = log.highWatermark();
                            if (currentOffset$1.elem >= currentHighWatermark) {
                                coordinator.updateLastWrittenOffset(Predef$.MODULE$.long2Long(currentOffset$1.elem));
                                if (currentHighWatermark > previousHighWatermark$1.elem) {
                                    coordinator.updateLastCommittedOffset(Predef$.MODULE$.long2Long(currentHighWatermark));
                                    previousHighWatermark$1.elem = currentHighWatermark;
                                    return;
                                }
                                return;
                            }
                        });
                        numBytes += memoryRecords2.sizeInBytes();
                    }
                    long endTimeMs = this.time.milliseconds();
                    if (this.logEndOffset$1(tp) == -1L) {
                        future.completeExceptionally(new NotLeaderOrFollowerException(new StringBuilder(93).append("Stopped loading records from ").append(tp).append(" because the partition is not online or is no longer the leader.").toString()));
                    } else if (this.isRunning().get()) {
                        future.complete(new CoordinatorLoader.LoadSummary(startTimeMs, endTimeMs, schedulerQueueTimeMs, (long)numRecords.elem, (long)numBytes));
                    } else {
                        future.completeExceptionally(new RuntimeException("Coordinator loader is closed."));
                    }
                    break block16;
                }
                throw new MatchError(option);
            }
            catch (Throwable ex) {
                future.completeExceptionally(ex);
            }
        }
    }

    public void close() {
        if (!this.isRunning().compareAndSet(true, false)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Coordinator loader is already shutting down.");
            return;
        }
        this.scheduler().shutdown();
    }

    private final long logEndOffset$1(TopicPartition tp$2) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(tp$2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
    }

    public static final /* synthetic */ void $anonfun$doLoad$4(CoordinatorPlayback coordinator$2, MutableRecordBatch batch$1, Record record) {
        block8: {
            block7: {
                ControlRecordType controlRecordType;
                ControlRecordType controlRecordType2;
                block6: {
                    ControlRecordType controlRecord;
                    ControlRecordType controlRecordType3 = controlRecord = ControlRecordType.parse((ByteBuffer)record.key());
                    ControlRecordType controlRecordType4 = ControlRecordType.COMMIT;
                    if (!(controlRecordType3 != null ? !controlRecordType3.equals(controlRecordType4) : controlRecordType4 != null)) {
                        coordinator$2.replayEndTransactionMarker(batch$1.producerId(), batch$1.producerEpoch(), TransactionResult.COMMIT);
                        return;
                    }
                    controlRecordType2 = controlRecord;
                    controlRecordType = ControlRecordType.ABORT;
                    if (controlRecordType2 != null) break block6;
                    if (controlRecordType != null) {
                        return;
                    }
                    break block7;
                }
                if (!controlRecordType2.equals(controlRecordType)) break block8;
            }
            coordinator$2.replayEndTransactionMarker(batch$1.producerId(), batch$1.producerEpoch(), TransactionResult.ABORT);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$doLoad$5(CoordinatorLoaderImpl $this, IntRef numRecords$1, CoordinatorPlayback coordinator$2, MutableRecordBatch batch$1, TopicPartition tp$2, Record record) {
        ++numRecords$1.elem;
        try {
            coordinator$2.replay(record.offset(), batch$1.producerId(), batch$1.producerEpoch(), $this.deserializer.deserialize(record.key(), record.value()));
            return;
        }
        catch (CoordinatorLoader.UnknownRecordTypeException ex) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(130).append("Unknown record type ").append(ex.unknownType()).append(" while loading offsets and group metadata ").append("from ").append(tp$2).append(". Ignoring it. It could be a left over from an aborted upgrade.").toString());
            return;
        }
    }

    public CoordinatorLoaderImpl(Time time, ReplicaManager replicaManager, Deserializer<T> deserializer, int loadBufferSize) {
        this.time = time;
        this.replicaManager = replicaManager;
        this.deserializer = deserializer;
        this.loadBufferSize = loadBufferSize;
        this.isRunning = new AtomicBoolean(true);
        this.scheduler = new KafkaScheduler(1);
        this.scheduler().startup();
    }
}

