/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.NotFoundException;

final class Entities {
    private Entities() {
    }

    static <T> T checkEntityExists(Optional<T> entity, String message, Object ... args) {
        return entity.orElseThrow(() -> new NotFoundException(String.format(message, args)));
    }

    static <T, K> Optional<T> findEntityByKey(Collection<T> entities, Function<T, K> toKey, K key) {
        return entities.stream().filter(entity -> {
            Object entityKey = toKey.apply(entity);
            return entityKey == null && key == null || entityKey != null && entityKey.equals(key);
        }).findAny();
    }
}

