/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.ConsumerLagManager;
import io.confluent.kafkarest.entities.ConsumerLag;
import io.confluent.kafkarest.entities.v3.ConsumerLagData;
import io.confluent.kafkarest.entities.v3.ConsumerLagDataList;
import io.confluent.kafkarest.entities.v3.GetConsumerLagResponse;
import io.confluent.kafkarest.entities.v3.ListConsumerLagsResponse;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;

@Path(value="/v3/clusters/{clusterId}/consumer-groups/{consumerGroupId}/lags")
@ResourceAccesslistFeature.ResourceName(value="api.v3.consumer-lags.*")
public final class ConsumerLagsResource {
    private final Provider<ConsumerLagManager> consumerLagManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public ConsumerLagsResource(Provider<ConsumerLagManager> consumerLagManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.consumerLagManager = Objects.requireNonNull(consumerLagManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.consumer-lags.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.consumer-lags.list")
    public void listConsumerLags(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="consumerGroupId") String consumerGroupId) {
        CompletionStage response = ((CompletableFuture)((ConsumerLagManager)this.consumerLagManager.get()).listConsumerLags(clusterId, consumerGroupId).thenApply(lags -> {
            if (lags.isEmpty()) {
                throw new NotFoundException("Consumer lags not found.");
            }
            return lags;
        })).thenApply(lags -> ListConsumerLagsResponse.create((ConsumerLagDataList)((ConsumerLagDataList.Builder)((ConsumerLagDataList.Builder)ConsumerLagDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", clusterId, "consumer-groups", consumerGroupId, "lags")).build())).setData(lags.stream().map(this::toConsumerLagData).sorted(Comparator.comparing(ConsumerLagData::getLag).reversed().thenComparing(ConsumerLagData::getTopicName).thenComparing(ConsumerLagData::getPartitionId)).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @GET
    @Path(value="/{topicName}/partitions/{partitionId}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.consumer-lags.get")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.consumer-lags.get")
    public void getConsumerLag(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="consumerGroupId") String consumerGroupId, @PathParam(value="topicName") String topicName, @PathParam(value="partitionId") Integer partitionId) {
        CompletionStage response = ((CompletableFuture)((ConsumerLagManager)this.consumerLagManager.get()).getConsumerLag(clusterId, consumerGroupId, topicName, partitionId).thenApply(lag -> (ConsumerLag)lag.orElseThrow(NotFoundException::new))).thenApply(lag -> GetConsumerLagResponse.create(this.toConsumerLagData((ConsumerLag)lag)));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    private ConsumerLagData toConsumerLagData(ConsumerLag lag) {
        return ((ConsumerLagData.Builder)ConsumerLagData.fromConsumerLag(lag).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", lag.getClusterId(), "consumer-groups", lag.getConsumerGroupId(), "lags", lag.getTopicName(), "partitions", Integer.toString(lag.getPartitionId()))).setResourceName(this.crnFactory.create("kafka", lag.getClusterId(), "consumer-group", lag.getConsumerGroupId(), "lag", lag.getTopicName(), "partition", Integer.toString(lag.getPartitionId()))).build())).build();
    }
}

