/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleaningException;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.log.UnifiedLog;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.SkimpyOffsetMap;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\r\u0005e\u0001B(Q\u0001UC\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\to\u0002\u0011)\u0019!C\u0001q\"I\u0011q\u0002\u0001\u0003\u0002\u0003\u0006I!\u001f\u0005\u000b\u0003#\u0001!Q1A\u0005\u0002\u0005M\u0001BCA\u0018\u0001\t\u0005\t\u0015!\u0003\u0002\u0016!Q\u0011\u0011\u0007\u0001\u0003\u0006\u0004%\t!a\r\t\u0015\u0005m\u0002A!A!\u0002\u0013\t)\u0004\u0003\u0006\u0002>\u0001\u0011\t\u0011)A\u0005\u0003\u007fAq!!\u0013\u0001\t\u0003\tY\u0005\u0003\u0006\u0002Z\u0001\u0011\r\u0011\"\u0001Q\u00037B\u0001\"a\u001b\u0001A\u0003%\u0011Q\f\u0005\n\u0003[\u0002\u0001\u0019!C\u0005\u0003_B\u0011\"!\u001d\u0001\u0001\u0004%I!a\u001d\t\u000f\u0005}\u0004\u0001)Q\u0005S\"Q\u0011\u0011\u0012\u0001C\u0002\u0013\u0005\u0001+a#\t\u0011\u0005M\u0005\u0001)A\u0005\u0003\u001bC!\"!&\u0001\u0005\u0004%\t\u0001UAL\u0011!\t\u0019\u000b\u0001Q\u0001\n\u0005e\u0005BCAS\u0001\t\u0007I\u0011\u0001)\u0002(\"A!q\u000f\u0001!\u0002\u0013\tI\u000b\u0003\u0005\u0003z\u0001!\t\u0001\u0015B>\u0011!\u0011i\t\u0001C\u0001!\n=\u0005b\u0002BI\u0001\u0011\u0005!Q\u0006\u0005\b\u0005'\u0003A\u0011\u0001B\u0017\u0011\u001d\u0011)\n\u0001C\u0001\u0005[AqAa&\u0001\t\u0003\u0012I\nC\u0004\u0003\"\u0002!\tEa)\t\u000f\t=\u0006\u0001\"\u0011\u00032\"9!\u0011\u0018\u0001\u0005\u0002\tm\u0006b\u0002B`\u0001\u0011\u0005!\u0011\u0019\u0005\n\u0005#\u0004\u0011\u0013!C\u0001\u0005'DqA!;\u0001\t\u0003\u0011Y\u000fC\u0004\u0003x\u0002!\tA!?\t\u000f\t}\b\u0001\"\u0001\u0004\u0002!911\u0002\u0001\u0005\u0002\r5\u0001bBB\t\u0001\u0011\u000511\u0003\u0005\b\u0007?\u0001A\u0011AB\u0011\u0011%\u0019Y\u0003AI\u0001\n\u0003\u0019i\u0003C\u0004\u00042\u0001!\taa\r\t\u0011\ru\u0002\u0001\"\u0001S\u0003_B\u0001ba\u0010\u0001\t\u0003\u0001&q\u0012\u0004\b\u0003s\u0003\u0001\u0001UA^\u0011)\tIM\u000bB\u0001B\u0003%\u00111\u001a\u0005\b\u0003\u0013RC\u0011AAi\u0011\u001d\t)N\u000bC)\u0003/D\u0011\"a<+\u0005\u0004%\t!!=\t\u0011\u0005e(\u0006)A\u0005\u0003gD\u0011\"a?+\u0001\u0004%\t!!@\t\u0013\t\u0015!\u00061A\u0005\u0002\t\u001d\u0001\u0002\u0003B\u0006U\u0001\u0006K!a@\t\u0013\t=!\u00061A\u0005\u0002\tE\u0001\"\u0003B\rU\u0001\u0007I\u0011\u0001B\u000e\u0011!\u0011yB\u000bQ!\n\tM\u0001b\u0002B\u0012U\u0011%!Q\u0005\u0005\b\u0005WQC\u0011\tB\u0017\u0011\u001d\u0011yC\u000bC\u0005\u0005cAqA!\u000f+\t\u0013\u0011\t\u0004C\u0004\u0003L)\"IA!\u0014\t\u000f\te#\u0006\"\u0003\u0003\\\u001d91\u0011\t)\t\u0002\r\rcAB(Q\u0011\u0003\u0019)\u0005C\u0004\u0002Ju\"\taa\u0012\t\u0013\r%SH1A\u0005\u0002\te\u0005\u0002CB&{\u0001\u0006IAa'\t\u000f\r5S\b\"\u0001\u0004P!Q11K\u001fC\u0002\u0013\u0005\u0001k!\u0016\t\u0011\r\u0005T\b)A\u0005\u0007/B\u0011ba\u0019>\u0005\u0004%Ia!\u0016\t\u0011\r\u0015T\b)A\u0005\u0007/B!ba\u001a>\u0005\u0004%\t\u0001UB+\u0011!\u0019I'\u0010Q\u0001\n\r]\u0003BCB6{\t\u0007I\u0011\u0001)\u0004V!A1QN\u001f!\u0002\u0013\u00199\u0006C\u0005\u0004pu\u0012\r\u0011\"\u0003\u0004V!A1\u0011O\u001f!\u0002\u0013\u00199\u0006\u0003\u0006\u0004tu\u0012\r\u0011\"\u0001Q\u0007kB\u0001b!\u001f>A\u0003%1q\u000f\u0005\n\u0007wj\u0014\u0013!C\u0001\u0007{\u0012!\u0002T8h\u00072,\u0017M\\3s\u0015\t\t&+A\u0002m_\u001eT\u0011aU\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001a\u000b\u00182\u0011\u0005]SV\"\u0001-\u000b\u0003e\u000bQa]2bY\u0006L!a\u0017-\u0003\r\u0005s\u0017PU3g!\ti\u0006-D\u0001_\u0015\ty&+A\u0003vi&d7/\u0003\u0002b=\n9Aj\\4hS:<\u0007CA2g\u001b\u0005!'BA3S\u0003\u0019\u0019XM\u001d<fe&\u0011q\r\u001a\u0002\u0015\u0005J|7.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3\u0002\u001b%t\u0017\u000e^5bY\u000e{gNZ5h!\tQW/D\u0001l\u0015\t\tFN\u0003\u0002n]\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0003_B\fqa\u001d;pe\u0006<WM\u0003\u0002Tc*\u0011!o]\u0001\u0007CB\f7\r[3\u000b\u0003Q\f1a\u001c:h\u0013\t18NA\u0007DY\u0016\fg.\u001a:D_:4\u0017nZ\u0001\bY><G)\u001b:t+\u0005I\bc\u0001>~\u007f6\t1P\u0003\u0002}1\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005y\\(aA*fcB!\u0011\u0011AA\u0006\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011AA5p\u0015\t\tI!\u0001\u0003kCZ\f\u0017\u0002BA\u0007\u0003\u0007\u0011AAR5mK\u0006AAn\\4ESJ\u001c\b%\u0001\u0003m_\u001e\u001cXCAA\u000b!\u001di\u0016qCA\u000e\u0003OI1!!\u0007_\u0005\u0011\u0001vn\u001c7\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\tq\u0003\u0019\u0019w.\\7p]&!\u0011QEA\u0010\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B!!\u000b\u0002,5\t\u0001+C\u0002\u0002.A\u0013!\"\u00168jM&,G\rT8h\u0003\u0015awnZ:!\u0003Qawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fYV\u0011\u0011Q\u0007\t\u0004U\u0006]\u0012bAA\u001dW\n!Bj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\fQ\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007%\u0001\u0003uS6,\u0007\u0003BA!\u0003\u000bj!!a\u0011\u000b\u0007}\u000by\"\u0003\u0003\u0002H\u0005\r#\u0001\u0002+j[\u0016\fa\u0001P5oSRtD\u0003DA'\u0003\u001f\n\t&a\u0015\u0002V\u0005]\u0003cAA\u0015\u0001!)\u0001.\u0003a\u0001S\")q/\u0003a\u0001s\"9\u0011\u0011C\u0005A\u0002\u0005U\u0001bBA\u0019\u0013\u0001\u0007\u0011Q\u0007\u0005\n\u0003{I\u0001\u0013!a\u0001\u0003\u007f\tA\"\\3ue&\u001c7o\u0012:pkB,\"!!\u0018\u0011\t\u0005}\u0013qM\u0007\u0003\u0003CRA!a\u0019\u0002f\u00059Q.\u001a;sS\u000e\u001c(BA3q\u0013\u0011\tI'!\u0019\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/A\u0007nKR\u0014\u0018nY:He>,\b\u000fI\u0001\u0007G>tg-[4\u0016\u0003%\f!bY8oM&<w\fJ3r)\u0011\t)(a\u001f\u0011\u0007]\u000b9(C\u0002\u0002za\u0013A!\u00168ji\"A\u0011QP\u0007\u0002\u0002\u0003\u0007\u0011.A\u0002yIE\nqaY8oM&<\u0007\u0005K\u0002\u000f\u0003\u0007\u00032aVAC\u0013\r\t9\t\u0017\u0002\tm>d\u0017\r^5mK\u0006q1\r\\3b]\u0016\u0014X*\u00198bO\u0016\u0014XCAAG!\u0011\tI#a$\n\u0007\u0005E\u0005KA\tM_\u001e\u001cE.Z1oKJl\u0015M\\1hKJ\fqb\u00197fC:,'/T1oC\u001e,'\u000fI\u0001\ni\"\u0014x\u000e\u001e;mKJ,\"!!'\u0011\t\u0005m\u0015qT\u0007\u0003\u0003;S!a\u00187\n\t\u0005\u0005\u0016Q\u0014\u0002\n)\"\u0014x\u000e\u001e;mKJ\f!\u0002\u001e5s_R$H.\u001a:!\u0003!\u0019G.Z1oKJ\u001cXCAAU!\u0019\tY+!-\u000266\u0011\u0011Q\u0016\u0006\u0004\u0003_[\u0018aB7vi\u0006\u0014G.Z\u0005\u0005\u0003g\u000biKA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bcAA\\U5\t\u0001AA\u0007DY\u0016\fg.\u001a:UQJ,\u0017\rZ\n\u0005U\u0005uF\f\u0005\u0003\u0002@\u0006\u0015WBAAa\u0015\u0011\t\u0019-!\u001a\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u000f\f\tM\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0017\u0001\u0003;ie\u0016\fG-\u00133\u0011\u0007]\u000bi-C\u0002\u0002Pb\u00131!\u00138u)\u0011\t),a5\t\u000f\u0005%G\u00061\u0001\u0002L\u0006QAn\\4hKJt\u0015-\\3\u0016\u0005\u0005e\u0007\u0003BAn\u0003StA!!8\u0002fB\u0019\u0011q\u001c-\u000e\u0005\u0005\u0005(bAAr)\u00061AH]8pizJ1!a:Y\u0003\u0019\u0001&/\u001a3fM&!\u00111^Aw\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u001d-\u0002\u000f\rdW-\u00198feV\u0011\u00111\u001f\t\u0005\u0003S\t)0C\u0002\u0002xB\u0013qa\u00117fC:,'/\u0001\u0005dY\u0016\fg.\u001a:!\u0003%a\u0017m\u001d;Ti\u0006$8/\u0006\u0002\u0002\u0000B!\u0011\u0011\u0006B\u0001\u0013\r\u0011\u0019\u0001\u0015\u0002\r\u00072,\u0017M\\3s'R\fGo]\u0001\u000eY\u0006\u001cHo\u0015;biN|F%Z9\u0015\t\u0005U$\u0011\u0002\u0005\n\u0003{\n\u0014\u0011!a\u0001\u0003\u007f\f!\u0002\\1tiN#\u0018\r^:!Q\r\u0011\u00141Q\u0001\u0012Y\u0006\u001cH\u000f\u0015:f\u00072,\u0017M\\*uCR\u001cXC\u0001B\n!\u0011\tIC!\u0006\n\u0007\t]\u0001KA\u0007Qe\u0016\u001cE.Z1o'R\fGo]\u0001\u0016Y\u0006\u001cH\u000f\u0015:f\u00072,\u0017M\\*uCR\u001cx\fJ3r)\u0011\t)H!\b\t\u0013\u0005uD'!AA\u0002\tM\u0011A\u00057bgR\u0004&/Z\"mK\u0006t7\u000b^1ug\u0002B3!NAB\u0003%\u0019\u0007.Z2l\t>tW\r\u0006\u0003\u0002v\t\u001d\u0002b\u0002B\u0015m\u0001\u0007\u00111D\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0003\u0019!wnV8sWR\u0011\u0011QO\u0001\u0015iJL8\t\\3b]\u001aKG\u000e\u001e5jKN$Hj\\4\u0015\u0005\tM\u0002cA,\u00036%\u0019!q\u0007-\u0003\u000f\t{w\u000e\\3b]\u0006\t2\r\\3b]\u001aKG\u000e\u001e5jKN$Hj\\4)\u000be\u0012iD!\u0013\u0011\u000b]\u0013yDa\u0011\n\u0007\t\u0005\u0003L\u0001\u0004uQJ|wo\u001d\t\u0005\u0003S\u0011)%C\u0002\u0003HA\u0013A\u0003T8h\u00072,\u0017M\\5oO\u0016C8-\u001a9uS>t7E\u0001B\"\u0003!\u0019G.Z1o\u0019><G\u0003BA;\u0005\u001fBqA!\u0015;\u0001\u0004\u0011\u0019&A\u0005dY\u0016\fg.\u00192mKB!\u0011\u0011\u0006B+\u0013\r\u00119\u0006\u0015\u0002\u000b\u0019><Gk\\\"mK\u0006t\u0017a\u0003:fG>\u0014Hm\u0015;biN$B\"!\u001e\u0003^\t\u0005$Q\rB8\u0005gBqAa\u0018<\u0001\u0004\tY-\u0001\u0002jI\"9!1M\u001eA\u0002\u0005e\u0017\u0001\u00028b[\u0016DqAa\u001a<\u0001\u0004\u0011I'\u0001\u0003ge>l\u0007cA,\u0003l%\u0019!Q\u000e-\u0003\t1{gn\u001a\u0005\b\u0005cZ\u0004\u0019\u0001B5\u0003\t!x\u000eC\u0004\u0003vm\u0002\r!a@\u0002\u000bM$\u0018\r^:\u0002\u0013\rdW-\u00198feN\u0004\u0013!F7bq>3XM]\"mK\u0006tWM\u001d+ie\u0016\fGm\u001d\u000b\u0005\u0005{\u0012\u0019\tE\u0002X\u0005\u007fJ1A!!Y\u0005\u0019!u.\u001e2mK\"9!QQ\u000bA\u0002\t\u001d\u0015!\u00014\u0011\u000f]\u0013I)!.\u0003~%\u0019!1\u0012-\u0003\u0013\u0019+hn\u0019;j_:\f\u0014a\u00043fC\u0012$\u0006N]3bI\u000e{WO\u001c;\u0016\u0005\u0005-\u0017aB:uCJ$X\u000f]\u0001\tg\",H\u000fZ8x]\u0006i!/Z7pm\u0016lU\r\u001e:jGN\fQC]3d_:4\u0017nZ;sC\ndWmQ8oM&<7/\u0006\u0002\u0003\u001cB)!P!(\u0002Z&\u0019!qT>\u0003\u0007M+G/A\fwC2LG-\u0019;f%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R!\u0011Q\u000fBS\u0011\u001d\u00119k\u0007a\u0001\u0005S\u000b\u0011B\\3x\u0007>tg-[4\u0011\u0007\r\u0014Y+C\u0002\u0003.\u0012\u00141bS1gW\u0006\u001cuN\u001c4jO\u0006Y!/Z2p]\u001aLw-\u001e:f)\u0019\t)Ha-\u00038\"9!Q\u0017\u000fA\u0002\t%\u0016!C8mI\u000e{gNZ5h\u0011\u001d\u00119\u000b\ba\u0001\u0005S\u000bQ\"\u00192peR\u001cE.Z1oS:<G\u0003BA;\u0005{CqA!\u000b\u001e\u0001\u0004\tY\"A\tva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN$b!!\u001e\u0003D\n\u001d\u0007B\u0002Bc=\u0001\u0007q0A\u0004eCR\fG)\u001b:\t\u0013\t%g\u0004%AA\u0002\t-\u0017!\u00059beRLG/[8o)>\u0014V-\\8wKB)qK!4\u0002\u001c%\u0019!q\u001a-\u0003\r=\u0003H/[8o\u0003m)\b\u000fZ1uK\u000eCWmY6q_&tGo\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u001b\u0016\u0005\u0005\u0017\u00149n\u000b\u0002\u0003ZB!!1\u001cBs\u001b\t\u0011iN\u0003\u0003\u0003`\n\u0005\u0018!C;oG\",7m[3e\u0015\r\u0011\u0019\u000fW\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bt\u0005;\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003I\tG\u000e^3s\u0007\",7m\u001b9pS:$H)\u001b:\u0015\u0011\u0005U$Q\u001eBx\u0005gDqA!\u000b!\u0001\u0004\tY\u0002\u0003\u0004\u0003r\u0002\u0002\ra`\u0001\rg>,(oY3M_\u001e$\u0015N\u001d\u0005\u0007\u0005k\u0004\u0003\u0019A@\u0002\u0015\u0011,7\u000f\u001e'pO\u0012K'/A\niC:$G.\u001a'pO\u0012K'OR1jYV\u0014X\r\u0006\u0003\u0002v\tm\bb\u0002B\u007fC\u0001\u0007\u0011\u0011\\\u0001\u0004I&\u0014\u0018aF7bs\n,GK];oG\u0006$Xm\u00115fG.\u0004x.\u001b8u)!\t)ha\u0001\u0004\u0006\r\u001d\u0001B\u0002BcE\u0001\u0007q\u0010C\u0004\u0003*\t\u0002\r!a\u0007\t\u000f\r%!\u00051\u0001\u0003j\u00051qN\u001a4tKR\fQ#\u00192peR\fe\u000e\u001a)bkN,7\t\\3b]&tw\r\u0006\u0003\u0002v\r=\u0001b\u0002B\u0015G\u0001\u0007\u00111D\u0001\u000fe\u0016\u001cX/\\3DY\u0016\fg.\u001b8h)\u0011\t)h!\u0006\t\u000f\r]A\u00051\u0001\u0004\u001a\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000fE\u0003{\u00077\tY\"C\u0002\u0004\u001em\u0014\u0001\"\u0013;fe\u0006\u0014G.Z\u0001\rC^\f\u0017\u000e^\"mK\u0006tW\r\u001a\u000b\t\u0005g\u0019\u0019c!\n\u0004(!9!\u0011F\u0013A\u0002\u0005m\u0001bBB\u0005K\u0001\u0007!\u0011\u000e\u0005\n\u0007S)\u0003\u0013!a\u0001\u0005S\n\u0011\"\\1y/\u0006LG/T:\u0002-\u0005<\u0018-\u001b;DY\u0016\fg.\u001a3%I\u00164\u0017-\u001e7uIM*\"aa\f+\t\t%$q[\u0001'a\u0006,8/Z\"mK\u0006t\u0017N\\4G_JtuN\\\"p[B\f7\r^3e!\u0006\u0014H/\u001b;j_:\u001cHCAB\u001b!\u0015Q81DB\u001c!\u001d96\u0011HA\u000e\u0003OI1aa\u000fY\u0005\u0019!V\u000f\u001d7fe\u0005i1-\u001e:sK:$8i\u001c8gS\u001e\fAb\u00197fC:,'oQ8v]R\f!\u0002T8h\u00072,\u0017M\\3s!\r\tI#P\n\u0003{Y#\"aa\u0011\u0002+I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hg\u00061\"+Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001c\b%A\u0007dY\u0016\fg.\u001a:D_:4\u0017n\u001a\u000b\u0004S\u000eE\u0003bBA7\u0003\u0002\u0007!\u0011V\u0001&\u001b\u0006D()\u001e4gKJ,F/\u001b7ju\u0006$\u0018n\u001c8QKJ\u001cWM\u001c;NKR\u0014\u0018n\u0019(b[\u0016,\"aa\u0016\u0011\t\re3qL\u0007\u0003\u00077RAa!\u0018\u0002\b\u0005!A.\u00198h\u0013\u0011\tYoa\u0017\u0002M5\u000b\u0007PQ;gM\u0016\u0014X\u000b^5mSj\fG/[8o!\u0016\u00148-\u001a8u\u001b\u0016$(/[2OC6,\u0007%\u0001\u0010DY\u0016\fg.\u001a:SK\u000e|\u0007/\u001f)fe\u000e,g\u000e^'fiJL7MT1nK\u0006y2\t\\3b]\u0016\u0014(+Z2paf\u0004VM]2f]RlU\r\u001e:jG:\u000bW.\u001a\u0011\u0002-5\u000b\u0007p\u00117fC:$\u0016.\\3NKR\u0014\u0018n\u0019(b[\u0016\fq#T1y\u00072,\u0017M\u001c+j[\u0016lU\r\u001e:jG:\u000bW.\u001a\u0011\u0002;5\u000b\u0007pQ8na\u0006\u001cG/[8o\t\u0016d\u0017-_'fiJL7m\u001d(b[\u0016\fa$T1y\u0007>l\u0007/Y2uS>tG)\u001a7bs6+GO]5dg:\u000bW.\u001a\u0011\u00023\u0011+\u0017\r\u001a+ie\u0016\fGmQ8v]RlU\r\u001e:jG:\u000bW.Z\u0001\u001b\t\u0016\fG\r\u00165sK\u0006$7i\\;oi6+GO]5d\u001d\u0006lW\rI\u0001\f\u001b\u0016$(/[2OC6,7/\u0006\u0002\u0004xA)!P!(\u0004X\u0005aQ*\u001a;sS\u000et\u0015-\\3tA\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"aa +\t\u0005}\"q\u001b")
public class LogCleaner
implements Logging,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, UnifiedLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private final KafkaMetricsGroup metricsGroup;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private final Throttler throttler;
    private final ArrayBuffer<CleanerThread> cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return Time.SYSTEM;
    }

    public static CleanerConfig cleanerConfig(KafkaConfig config) {
        return LogCleaner$.MODULE$.cleanerConfig(config);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, UnifiedLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public ArrayBuffer<CleanerThread> cleaners() {
        return this.cleaners;
    }

    public double maxOverCleanerThreads(Function1<CleanerThread, Object> f) {
        return BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)f.apply((Object)thread))))));
    }

    public int deadThreadCount() {
        return this.cleaners().count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isThreadFailed()));
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting the log cleaner");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            CleanerThread cleaner = new CleanerThread(i);
            this.cleaners().$plus$eq((Object)cleaner);
            cleaner.start();
        });
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down the log cleaner.");
        try {
            this.cleaners().foreach((Function1 & Serializable)x$8 -> {
                x$8.shutdown();
                return BoxedUnit.UNIT;
            });
            this.cleaners().clear();
        }
        finally {
            this.removeMetrics();
        }
    }

    public void removeMetrics() {
        LogCleaner$.MODULE$.MetricNames().foreach((Function1 & Serializable)x$1 -> {
            LogCleaner.$anonfun$removeMetrics$1(this, x$1);
            return BoxedUnit.UNIT;
        });
        this.cleanerManager().removeMetrics();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        int numThreads = LogCleaner$.MODULE$.cleanerConfig((KafkaConfig)newConfig).numThreads;
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads;
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        double maxIoBytesPerSecond = this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond;
        if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToDouble((double)maxIoBytesPerSecond), (Object)oldConfig.logCleanerIoMaxBytesPerSecond())) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Updating logCleanerIoMaxBytesPerSecond: ").append(maxIoBytesPerSecond).toString());
            this.throttler().updateDesiredRatePerSec(maxIoBytesPerSecond);
        }
        this.shutdown();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir, Option<TopicPartition> partitionToRemove) {
        Option<Tuple2<TopicPartition, Object>> x$3 = this.cleanerManager().updateCheckpoints$default$2();
        this.cleanerManager().updateCheckpoints(dataDir, x$3, partitionToRemove);
    }

    public Option<TopicPartition> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, UnifiedLog>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.cleaners().size();
    }

    public static final /* synthetic */ double $anonfun$new$2(CleanerThread x$1) {
        return x$1.lastStats().bufferUtilization();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$1() {
        return (int)(this.maxOverCleanerThreads((Function1<CleanerThread, Object>)(Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$2(x$1))) * (double)100);
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$3() {
        ArrayBuffer stats = (ArrayBuffer)this.cleaners().map((Function1 & Serializable)x$2 -> x$2.lastStats());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$new$8(CleanerThread x$5) {
        return x$5.lastStats().elapsedSecs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$7() {
        return (int)this.maxOverCleanerThreads((Function1<CleanerThread, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$8(x$5)));
    }

    public static final /* synthetic */ double $anonfun$new$10(CleanerThread x$6) {
        return x$6.lastPreCleanStats().maxCompactionDelayMs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$9() {
        return (int)(this.maxOverCleanerThreads((Function1<CleanerThread, Object>)(Function1 & Serializable)x$6 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$10(x$6))) / (double)1000);
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$11() {
        return this.deadThreadCount();
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$1(LogCleaner $this, String x$1) {
        $this.metricsGroup().removeMetric(x$1);
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable)x$9 -> x$9 >= offset$1));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, UnifiedLog> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond, 300L, "cleaner-io", "bytes", time);
        this.cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.MaxBufferUtilizationPercentMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$CleanerRecopyPercentMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$3();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.MaxCleanTimeMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$7();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.MaxCompactionDelayMetricsName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$9();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$DeadThreadCountMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                LogCleaner logCleaner = this.$outer;
                if (logCleaner == null) {
                    throw null;
                }
                return logCleaner.deadThreadCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public class CleanerThread
    extends ShutdownableThread
    implements Logging {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        public void doWork() {
            if (!this.tryCleanFilthiestLog()) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backoffMs, TimeUnit.MILLISECONDS);
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().maintainUncleanablePartitions();
        }

        private boolean tryCleanFilthiestLog() {
            try {
                return this.cleanFilthiestLog();
            }
            catch (LogCleaningException e) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(e.log()).append(". Marking its partition (").append(e.log().topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(e.log().parentDir(), e.log().topicPartition());
                return false;
            }
        }

        private boolean cleanFilthiestLog() throws LogCleaningException {
            boolean bl;
            PreCleanStats preCleanStats = new PreCleanStats();
            Option<LogToClean> ltc = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
            if (None$.MODULE$.equals(ltc)) {
                bl = false;
            } else if (ltc instanceof Some) {
                LogToClean cleanable = (LogToClean)((Some)ltc).value();
                this.lastPreCleanStats_$eq(preCleanStats);
                try {
                    this.cleanLog(cleanable);
                    bl = true;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(cleanable.log(), exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            } else {
                throw new MatchError(ltc);
            }
            boolean cleaned = bl;
            Iterable<Tuple2<TopicPartition, UnifiedLog>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
            try {
                deletable.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)CleanerThread.$anonfun$cleanFilthiestLog$1(x0$1)));
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable)x$10 -> (TopicPartition)x$10._1())));
            }
            return cleaned;
        }

        /*
         * WARNING - void declaration
         */
        private void cleanLog(LogToClean cleanable) {
            long startOffset;
            long endOffset = startOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    void var9_6;
                    void var7_5;
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    endOffset = var7_5;
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), startOffset, (long)var7_5, (CleanerStats)var9_6);
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().parentDir();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().parentDirFile(), endOffset);
            }
        }

        private void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = new StringBuilder(0).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / stats.elapsedSecs() / (double)0x100000))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000 / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000 / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesWritten() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)(Function0 & Serializable)() -> message);
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.lastPreCleanStats().maxCompactionDelayMs())})));
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
                return;
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ int $anonfun$cleanFilthiestLog$1(Tuple2 x0$1) {
            if (x0$1 != null) {
                UnifiedLog log = (UnifiedLog)x0$1._2();
                try {
                    return log.deleteOldSegments();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(log, exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            }
            throw new MatchError(null);
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            this.logIdent_$eq(this.logPrefix);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, (OffsetMap)new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads, Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize, LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor, LogCleaner.this.throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            });
            this.lastStats = new CleanerStats(Time.SYSTEM);
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

