/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.converters;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafkarest.converters.ConversionException;
import io.confluent.kafkarest.converters.SchemaConverter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AvroConverter
implements SchemaConverter {
    private static final Logger log = LoggerFactory.getLogger(AvroConverter.class);
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    @Override
    public SchemaConverter.JsonNodeAndSize toJson(Object value) {
        try {
            byte[] bytes = AvroSchemaUtils.toJson((Object)value);
            if (bytes == null) {
                return new SchemaConverter.JsonNodeAndSize((JsonNode)NullNode.getInstance(), 0L);
            }
            return new SchemaConverter.JsonNodeAndSize(JSON_MAPPER.readTree(bytes), bytes.length);
        }
        catch (IOException e) {
            log.error("Jackson failed to deserialize JSON generated by Avro's JSON encoder: ", (Throwable)e);
            throw new ConversionException("Failed to convert Avro to JSON: " + e.getMessage());
        }
        catch (RuntimeException e) {
            log.error("Unexpected exception converting Avro to JSON: ", (Throwable)e);
            throw new ConversionException("Failed to convert Avro to JSON: " + e.getMessage());
        }
    }
}

